/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.model.InitializersAssert;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.OwnerReference;
import io.fabric8.kubernetes.api.model.OwnerReferenceAssert;
import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.StringAssert;
import org.assertj.core.util.Objects;

public abstract class AbstractObjectMetaAssert<S extends AbstractObjectMetaAssert<S, A>, A extends ObjectMeta>
extends AbstractAssert<S, A> {
    protected AbstractObjectMetaAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public MapAssert additionalProperties() {
        this.isNotNull();
        return (MapAssert)Assertions.assertThat(((ObjectMeta)this.actual).getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"), new Object[0]);
    }

    public MapAssert annotations() {
        this.isNotNull();
        return (MapAssert)Assertions.assertThat(((ObjectMeta)this.actual).getAnnotations()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "annotations"), new Object[0]);
    }

    public StringAssert clusterName() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((ObjectMeta)this.actual).getClusterName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "clusterName"), new Object[0]);
    }

    public StringAssert creationTimestamp() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((ObjectMeta)this.actual).getCreationTimestamp()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "creationTimestamp"), new Object[0]);
    }

    public S hasDeletionGracePeriodSeconds(Long deletionGracePeriodSeconds) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting deletionGracePeriodSeconds of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Long actualDeletionGracePeriodSeconds = ((ObjectMeta)this.actual).getDeletionGracePeriodSeconds();
        if (!Objects.areEqual((Object)actualDeletionGracePeriodSeconds, (Object)deletionGracePeriodSeconds)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, deletionGracePeriodSeconds, actualDeletionGracePeriodSeconds});
        }
        return (S)((Object)((AbstractObjectMetaAssert)this.myself));
    }

    public StringAssert deletionTimestamp() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((ObjectMeta)this.actual).getDeletionTimestamp()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "deletionTimestamp"), new Object[0]);
    }

    public NavigationListAssert<String, StringAssert> finalizers() {
        this.isNotNull();
        AssertFactory<String, StringAssert> assertFactory = new AssertFactory<String, StringAssert>(){

            @Override
            public StringAssert createAssert(String t) {
                return (StringAssert)Assertions.assertThat((String)t);
            }
        };
        NavigationListAssert<String, StringAssert> answer = new NavigationListAssert<String, StringAssert>(((ObjectMeta)this.actual).getFinalizers(), assertFactory);
        answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "finalizers"), new Object[0]);
        return answer;
    }

    public StringAssert generateName() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((ObjectMeta)this.actual).getGenerateName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "generateName"), new Object[0]);
    }

    public S hasGeneration(Long generation) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting generation of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Long actualGeneration = ((ObjectMeta)this.actual).getGeneration();
        if (!Objects.areEqual((Object)actualGeneration, (Object)generation)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, generation, actualGeneration});
        }
        return (S)((Object)((AbstractObjectMetaAssert)this.myself));
    }

    public InitializersAssert initializers() {
        this.isNotNull();
        return (InitializersAssert)io.fabric8.openshift.assertions.Assertions.assertThat(((ObjectMeta)this.actual).getInitializers()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "initializers"), new Object[0]);
    }

    public MapAssert labels() {
        this.isNotNull();
        return (MapAssert)Assertions.assertThat(((ObjectMeta)this.actual).getLabels()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "labels"), new Object[0]);
    }

    public StringAssert name() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((ObjectMeta)this.actual).getName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "name"), new Object[0]);
    }

    public StringAssert namespace() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((ObjectMeta)this.actual).getNamespace()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "namespace"), new Object[0]);
    }

    public NavigationListAssert<OwnerReference, OwnerReferenceAssert> ownerReferences() {
        this.isNotNull();
        AssertFactory<OwnerReference, OwnerReferenceAssert> assertFactory = new AssertFactory<OwnerReference, OwnerReferenceAssert>(){

            @Override
            public OwnerReferenceAssert createAssert(OwnerReference t) {
                return io.fabric8.openshift.assertions.Assertions.assertThat(t);
            }
        };
        NavigationListAssert<OwnerReference, OwnerReferenceAssert> answer = new NavigationListAssert<OwnerReference, OwnerReferenceAssert>(((ObjectMeta)this.actual).getOwnerReferences(), assertFactory);
        answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "ownerReferences"), new Object[0]);
        return answer;
    }

    public StringAssert resourceVersion() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((ObjectMeta)this.actual).getResourceVersion()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "resourceVersion"), new Object[0]);
    }

    public StringAssert selfLink() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((ObjectMeta)this.actual).getSelfLink()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "selfLink"), new Object[0]);
    }

    public StringAssert uid() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((ObjectMeta)this.actual).getUid()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "uid"), new Object[0]);
    }
}

