/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerAssert;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceAssert;
import io.fabric8.kubernetes.api.model.PodSecurityContextAssert;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.VolumeAssert;
import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.BooleanAssert;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.StringAssert;
import org.assertj.core.util.Objects;

public abstract class AbstractPodSpecAssert<S extends AbstractPodSpecAssert<S, A>, A extends PodSpec>
extends AbstractAssert<S, A> {
    protected AbstractPodSpecAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public S hasActiveDeadlineSeconds(Long activeDeadlineSeconds) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting activeDeadlineSeconds of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Long actualActiveDeadlineSeconds = ((PodSpec)this.actual).getActiveDeadlineSeconds();
        if (!Objects.areEqual((Object)actualActiveDeadlineSeconds, (Object)activeDeadlineSeconds)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, activeDeadlineSeconds, actualActiveDeadlineSeconds});
        }
        return (S)((Object)((AbstractPodSpecAssert)this.myself));
    }

    public MapAssert additionalProperties() {
        this.isNotNull();
        return (MapAssert)Assertions.assertThat(((PodSpec)this.actual).getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"), new Object[0]);
    }

    public NavigationListAssert<Container, ContainerAssert> containers() {
        this.isNotNull();
        AssertFactory<Container, ContainerAssert> assertFactory = new AssertFactory<Container, ContainerAssert>(){

            @Override
            public ContainerAssert createAssert(Container t) {
                return io.fabric8.openshift.assertions.Assertions.assertThat(t);
            }
        };
        NavigationListAssert<Container, ContainerAssert> answer = new NavigationListAssert<Container, ContainerAssert>(((PodSpec)this.actual).getContainers(), assertFactory);
        answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "containers"), new Object[0]);
        return answer;
    }

    public StringAssert dnsPolicy() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((PodSpec)this.actual).getDnsPolicy()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "dnsPolicy"), new Object[0]);
    }

    public BooleanAssert hostIPC() {
        this.isNotNull();
        return (BooleanAssert)Assertions.assertThat((Boolean)((PodSpec)this.actual).getHostIPC()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "hostIPC"), new Object[0]);
    }

    public BooleanAssert hostNetwork() {
        this.isNotNull();
        return (BooleanAssert)Assertions.assertThat((Boolean)((PodSpec)this.actual).getHostNetwork()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "hostNetwork"), new Object[0]);
    }

    public BooleanAssert hostPID() {
        this.isNotNull();
        return (BooleanAssert)Assertions.assertThat((Boolean)((PodSpec)this.actual).getHostPID()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "hostPID"), new Object[0]);
    }

    public StringAssert hostname() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((PodSpec)this.actual).getHostname()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "hostname"), new Object[0]);
    }

    public NavigationListAssert<LocalObjectReference, LocalObjectReferenceAssert> imagePullSecrets() {
        this.isNotNull();
        AssertFactory<LocalObjectReference, LocalObjectReferenceAssert> assertFactory = new AssertFactory<LocalObjectReference, LocalObjectReferenceAssert>(){

            @Override
            public LocalObjectReferenceAssert createAssert(LocalObjectReference t) {
                return io.fabric8.openshift.assertions.Assertions.assertThat(t);
            }
        };
        NavigationListAssert<LocalObjectReference, LocalObjectReferenceAssert> answer = new NavigationListAssert<LocalObjectReference, LocalObjectReferenceAssert>(((PodSpec)this.actual).getImagePullSecrets(), assertFactory);
        answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "imagePullSecrets"), new Object[0]);
        return answer;
    }

    public StringAssert nodeName() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((PodSpec)this.actual).getNodeName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "nodeName"), new Object[0]);
    }

    public MapAssert nodeSelector() {
        this.isNotNull();
        return (MapAssert)Assertions.assertThat(((PodSpec)this.actual).getNodeSelector()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "nodeSelector"), new Object[0]);
    }

    public StringAssert restartPolicy() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((PodSpec)this.actual).getRestartPolicy()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "restartPolicy"), new Object[0]);
    }

    public PodSecurityContextAssert securityContext() {
        this.isNotNull();
        return (PodSecurityContextAssert)io.fabric8.openshift.assertions.Assertions.assertThat(((PodSpec)this.actual).getSecurityContext()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "securityContext"), new Object[0]);
    }

    public StringAssert serviceAccount() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((PodSpec)this.actual).getServiceAccount()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "serviceAccount"), new Object[0]);
    }

    public StringAssert serviceAccountName() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((PodSpec)this.actual).getServiceAccountName()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "serviceAccountName"), new Object[0]);
    }

    public StringAssert subdomain() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((PodSpec)this.actual).getSubdomain()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "subdomain"), new Object[0]);
    }

    public S hasTerminationGracePeriodSeconds(Long terminationGracePeriodSeconds) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting terminationGracePeriodSeconds of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Long actualTerminationGracePeriodSeconds = ((PodSpec)this.actual).getTerminationGracePeriodSeconds();
        if (!Objects.areEqual((Object)actualTerminationGracePeriodSeconds, (Object)terminationGracePeriodSeconds)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, terminationGracePeriodSeconds, actualTerminationGracePeriodSeconds});
        }
        return (S)((Object)((AbstractPodSpecAssert)this.myself));
    }

    public NavigationListAssert<Volume, VolumeAssert> volumes() {
        this.isNotNull();
        AssertFactory<Volume, VolumeAssert> assertFactory = new AssertFactory<Volume, VolumeAssert>(){

            @Override
            public VolumeAssert createAssert(Volume t) {
                return io.fabric8.openshift.assertions.Assertions.assertThat(t);
            }
        };
        NavigationListAssert<Volume, VolumeAssert> answer = new NavigationListAssert<Volume, VolumeAssert>(((PodSpec)this.actual).getVolumes(), assertFactory);
        answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "volumes"), new Object[0]);
        return answer;
    }
}

