/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.assertions;

import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.EndpointsList;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LabelSelectorRequirement;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceAssert;
import io.fabric8.kubernetes.api.model.ServiceSpec;
import io.fabric8.kubernetes.api.model.ServiceSpecAssert;
import io.fabric8.kubernetes.assertions.HasPodSelectionAssert;
import io.fabric8.kubernetes.assertions.PodSelectionAssert;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import java.util.List;
import java.util.Map;

public class ServicePodsAssert
extends ServiceAssert
implements HasPodSelectionAssert {
    private final KubernetesClient client;

    public ServicePodsAssert(KubernetesClient client, Service actual) {
        super(actual);
        this.client = client;
    }

    @Override
    public PodSelectionAssert pods() {
        ((ServiceSpecAssert)this.spec().isNotNull()).selector().isNotNull();
        ServiceSpec spec = ((Service)this.actual).getSpec();
        int replicas = 1;
        LabelSelector selector = null;
        Map<String, String> matchLabels = spec.getSelector();
        List<LabelSelectorRequirement> matchExpressions = selector.getMatchExpressions();
        return new PodSelectionAssert(this.client, replicas, matchLabels, matchExpressions, "Service " + KubernetesHelper.getName((HasMetadata)((HasMetadata)this.actual)));
    }

    public ServicePodsAssert hasEndpointOrReadyPod() {
        return this.hasEndpointOrReadyPod(PodSelectionAssert.getDefaultNotReadyTimeoutMs(), PodSelectionAssert.getDefaultReadyPeriodMs());
    }

    public ServicePodsAssert hasEndpointOrReadyPod(long notReadyTimeoutMS, long readyPeriodMS) {
        List<Endpoints> items;
        EndpointsList list = (EndpointsList)((FilterWatchListDeletable)this.client.endpoints().withLabels(KubernetesHelper.getLabels((HasMetadata)((HasMetadata)this.actual)))).list();
        if (list != null && (items = list.getItems()).size() > 0) {
            return this;
        }
        this.pods().isPodReadyForPeriod(notReadyTimeoutMS, readyPeriodMS);
        return this;
    }
}

