/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.model.AttachedVolume;
import io.fabric8.kubernetes.api.model.AttachedVolumeAssert;
import io.fabric8.kubernetes.api.model.ContainerImage;
import io.fabric8.kubernetes.api.model.ContainerImageAssert;
import io.fabric8.kubernetes.api.model.NodeAddress;
import io.fabric8.kubernetes.api.model.NodeAddressAssert;
import io.fabric8.kubernetes.api.model.NodeCondition;
import io.fabric8.kubernetes.api.model.NodeConditionAssert;
import io.fabric8.kubernetes.api.model.NodeDaemonEndpointsAssert;
import io.fabric8.kubernetes.api.model.NodeStatus;
import io.fabric8.kubernetes.api.model.NodeSystemInfoAssert;
import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.StringAssert;

public abstract class AbstractNodeStatusAssert<S extends AbstractNodeStatusAssert<S, A>, A extends NodeStatus>
extends AbstractAssert<S, A> {
    protected AbstractNodeStatusAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public MapAssert additionalProperties() {
        this.isNotNull();
        return (MapAssert)Assertions.assertThat(((NodeStatus)this.actual).getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"), new Object[0]);
    }

    public NavigationListAssert<NodeAddress, NodeAddressAssert> addresses() {
        this.isNotNull();
        AssertFactory<NodeAddress, NodeAddressAssert> assertFactory = new AssertFactory<NodeAddress, NodeAddressAssert>(){

            @Override
            public NodeAddressAssert createAssert(NodeAddress t) {
                return io.fabric8.openshift.assertions.Assertions.assertThat(t);
            }
        };
        NavigationListAssert<NodeAddress, NodeAddressAssert> answer = new NavigationListAssert<NodeAddress, NodeAddressAssert>(((NodeStatus)this.actual).getAddresses(), assertFactory);
        answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "addresses"), new Object[0]);
        return answer;
    }

    public MapAssert allocatable() {
        this.isNotNull();
        return (MapAssert)Assertions.assertThat(((NodeStatus)this.actual).getAllocatable()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "allocatable"), new Object[0]);
    }

    public MapAssert capacity() {
        this.isNotNull();
        return (MapAssert)Assertions.assertThat(((NodeStatus)this.actual).getCapacity()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "capacity"), new Object[0]);
    }

    public NavigationListAssert<NodeCondition, NodeConditionAssert> conditions() {
        this.isNotNull();
        AssertFactory<NodeCondition, NodeConditionAssert> assertFactory = new AssertFactory<NodeCondition, NodeConditionAssert>(){

            @Override
            public NodeConditionAssert createAssert(NodeCondition t) {
                return io.fabric8.openshift.assertions.Assertions.assertThat(t);
            }
        };
        NavigationListAssert<NodeCondition, NodeConditionAssert> answer = new NavigationListAssert<NodeCondition, NodeConditionAssert>(((NodeStatus)this.actual).getConditions(), assertFactory);
        answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "conditions"), new Object[0]);
        return answer;
    }

    public NodeDaemonEndpointsAssert daemonEndpoints() {
        this.isNotNull();
        return (NodeDaemonEndpointsAssert)io.fabric8.openshift.assertions.Assertions.assertThat(((NodeStatus)this.actual).getDaemonEndpoints()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "daemonEndpoints"), new Object[0]);
    }

    public NavigationListAssert<ContainerImage, ContainerImageAssert> images() {
        this.isNotNull();
        AssertFactory<ContainerImage, ContainerImageAssert> assertFactory = new AssertFactory<ContainerImage, ContainerImageAssert>(){

            @Override
            public ContainerImageAssert createAssert(ContainerImage t) {
                return io.fabric8.openshift.assertions.Assertions.assertThat(t);
            }
        };
        NavigationListAssert<ContainerImage, ContainerImageAssert> answer = new NavigationListAssert<ContainerImage, ContainerImageAssert>(((NodeStatus)this.actual).getImages(), assertFactory);
        answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "images"), new Object[0]);
        return answer;
    }

    public NodeSystemInfoAssert nodeInfo() {
        this.isNotNull();
        return (NodeSystemInfoAssert)io.fabric8.openshift.assertions.Assertions.assertThat(((NodeStatus)this.actual).getNodeInfo()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "nodeInfo"), new Object[0]);
    }

    public StringAssert phase() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((NodeStatus)this.actual).getPhase()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "phase"), new Object[0]);
    }

    public NavigationListAssert<AttachedVolume, AttachedVolumeAssert> volumesAttached() {
        this.isNotNull();
        AssertFactory<AttachedVolume, AttachedVolumeAssert> assertFactory = new AssertFactory<AttachedVolume, AttachedVolumeAssert>(){

            @Override
            public AttachedVolumeAssert createAssert(AttachedVolume t) {
                return io.fabric8.openshift.assertions.Assertions.assertThat(t);
            }
        };
        NavigationListAssert<AttachedVolume, AttachedVolumeAssert> answer = new NavigationListAssert<AttachedVolume, AttachedVolumeAssert>(((NodeStatus)this.actual).getVolumesAttached(), assertFactory);
        answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "volumesAttached"), new Object[0]);
        return answer;
    }

    public NavigationListAssert<String, StringAssert> volumesInUse() {
        this.isNotNull();
        AssertFactory<String, StringAssert> assertFactory = new AssertFactory<String, StringAssert>(){

            @Override
            public StringAssert createAssert(String t) {
                return (StringAssert)Assertions.assertThat((String)t);
            }
        };
        NavigationListAssert<String, StringAssert> answer = new NavigationListAssert<String, StringAssert>(((NodeStatus)this.actual).getVolumesInUse(), assertFactory);
        answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "volumesInUse"), new Object[0]);
        return answer;
    }
}

