/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.Event;
import io.fabric8.kubernetes.api.model.EventFluent;
import io.fabric8.kubernetes.api.model.EventSource;
import io.fabric8.kubernetes.api.model.EventSourceBuilder;
import io.fabric8.kubernetes.api.model.EventSourceFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import java.util.HashMap;
import java.util.Map;

public class EventFluentImpl<T extends EventFluent<T>>
extends BaseFluent<T>
implements EventFluent<T> {
    Event.ApiVersion apiVersion;
    Integer count;
    String firstTimestamp;
    VisitableBuilder<ObjectReference, ?> involvedObject;
    String kind;
    String lastTimestamp;
    String message;
    VisitableBuilder<ObjectMeta, ?> metadata;
    String reason;
    VisitableBuilder<EventSource, ?> source;
    String type;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public EventFluentImpl() {
    }

    public EventFluentImpl(Event instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withCount(instance.getCount());
        this.withFirstTimestamp(instance.getFirstTimestamp());
        this.withInvolvedObject(instance.getInvolvedObject());
        this.withKind(instance.getKind());
        this.withLastTimestamp(instance.getLastTimestamp());
        this.withMessage(instance.getMessage());
        this.withMetadata(instance.getMetadata());
        this.withReason(instance.getReason());
        this.withSource(instance.getSource());
        this.withType(instance.getType());
    }

    @Override
    public Event.ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public T withApiVersion(Event.ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
        return (T)this;
    }

    @Override
    public Integer getCount() {
        return this.count;
    }

    @Override
    public T withCount(Integer count) {
        this.count = count;
        return (T)this;
    }

    @Override
    public String getFirstTimestamp() {
        return this.firstTimestamp;
    }

    @Override
    public T withFirstTimestamp(String firstTimestamp) {
        this.firstTimestamp = firstTimestamp;
        return (T)this;
    }

    @Override
    public ObjectReference getInvolvedObject() {
        return this.involvedObject != null ? (ObjectReference)this.involvedObject.build() : null;
    }

    @Override
    public T withInvolvedObject(ObjectReference involvedObject) {
        if (involvedObject != null) {
            this.involvedObject = new ObjectReferenceBuilder(involvedObject);
            this._visitables.add(this.involvedObject);
        }
        return (T)this;
    }

    @Override
    public EventFluent.InvolvedObjectNested<T> withNewInvolvedObject() {
        return new InvolvedObjectNestedImpl();
    }

    @Override
    public EventFluent.InvolvedObjectNested<T> withNewInvolvedObjectLike(ObjectReference item) {
        return new InvolvedObjectNestedImpl(item);
    }

    @Override
    public EventFluent.InvolvedObjectNested<T> editInvolvedObject() {
        return this.withNewInvolvedObjectLike(this.getInvolvedObject());
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public T withKind(String kind) {
        this.kind = kind;
        return (T)this;
    }

    @Override
    public String getLastTimestamp() {
        return this.lastTimestamp;
    }

    @Override
    public T withLastTimestamp(String lastTimestamp) {
        this.lastTimestamp = lastTimestamp;
        return (T)this;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public T withMessage(String message) {
        this.message = message;
        return (T)this;
    }

    @Override
    public ObjectMeta getMetadata() {
        return this.metadata != null ? (ObjectMeta)this.metadata.build() : null;
    }

    @Override
    public T withMetadata(ObjectMeta metadata) {
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (T)this;
    }

    @Override
    public EventFluent.MetadataNested<T> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public EventFluent.MetadataNested<T> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public EventFluent.MetadataNested<T> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    @Override
    public T withReason(String reason) {
        this.reason = reason;
        return (T)this;
    }

    @Override
    public EventSource getSource() {
        return this.source != null ? (EventSource)this.source.build() : null;
    }

    @Override
    public T withSource(EventSource source) {
        if (source != null) {
            this.source = new EventSourceBuilder(source);
            this._visitables.add(this.source);
        }
        return (T)this;
    }

    @Override
    public EventFluent.SourceNested<T> withNewSource() {
        return new SourceNestedImpl();
    }

    @Override
    public EventFluent.SourceNested<T> withNewSourceLike(EventSource item) {
        return new SourceNestedImpl(item);
    }

    @Override
    public EventFluent.SourceNested<T> editSource() {
        return this.withNewSourceLike(this.getSource());
    }

    @Override
    public T withNewSource(String component, String host) {
        return this.withSource(new EventSource(component, host));
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public T withType(String type) {
        this.type = type;
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.additionalProperties.remove(key);
            }
        }
        return (T)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventFluentImpl that = (EventFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals((Object)that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.count != null ? !this.count.equals(that.count) : that.count != null) {
            return false;
        }
        if (this.firstTimestamp != null ? !this.firstTimestamp.equals(that.firstTimestamp) : that.firstTimestamp != null) {
            return false;
        }
        if (this.involvedObject != null ? !this.involvedObject.equals(that.involvedObject) : that.involvedObject != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.lastTimestamp != null ? !this.lastTimestamp.equals(that.lastTimestamp) : that.lastTimestamp != null) {
            return false;
        }
        if (this.message != null ? !this.message.equals(that.message) : that.message != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.reason != null ? !this.reason.equals(that.reason) : that.reason != null) {
            return false;
        }
        if (this.source != null ? !this.source.equals(that.source) : that.source != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class SourceNestedImpl<N>
    extends EventSourceFluentImpl<EventFluent.SourceNested<N>>
    implements EventFluent.SourceNested<N> {
        private final EventSourceBuilder builder;

        SourceNestedImpl(EventSource item) {
            this.builder = new EventSourceBuilder(this, item);
        }

        SourceNestedImpl() {
            this.builder = new EventSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)EventFluentImpl.this.withSource(this.builder.build());
        }

        @Override
        public N endSource() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<EventFluent.MetadataNested<N>>
    implements EventFluent.MetadataNested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)EventFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }

    public class InvolvedObjectNestedImpl<N>
    extends ObjectReferenceFluentImpl<EventFluent.InvolvedObjectNested<N>>
    implements EventFluent.InvolvedObjectNested<N> {
        private final ObjectReferenceBuilder builder;

        InvolvedObjectNestedImpl() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        InvolvedObjectNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)EventFluentImpl.this.withInvolvedObject(this.builder.build());
        }

        @Override
        public N endInvolvedObject() {
            return this.and();
        }
    }
}

