/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.openshift.api.model.ImageStreamSpec;
import io.fabric8.openshift.api.model.TagReference;
import java.util.Map;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

public abstract class AbstractImageStreamSpecAssert<S extends AbstractImageStreamSpecAssert<S, A>, A extends ImageStreamSpec>
extends AbstractAssert<S, A> {
    protected AbstractImageStreamSpecAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public S hasAdditionalProperties(Map additionalProperties) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Map<String, Object> actualAdditionalProperties = ((ImageStreamSpec)this.actual).getAdditionalProperties();
        if (!Objects.areEqual(actualAdditionalProperties, (Object)additionalProperties)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, additionalProperties, actualAdditionalProperties});
        }
        return (S)((Object)((AbstractImageStreamSpecAssert)this.myself));
    }

    public S hasDockerImageRepository(String dockerImageRepository) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting dockerImageRepository of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualDockerImageRepository = ((ImageStreamSpec)this.actual).getDockerImageRepository();
        if (!Objects.areEqual((Object)actualDockerImageRepository, (Object)dockerImageRepository)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, dockerImageRepository, actualDockerImageRepository});
        }
        return (S)((Object)((AbstractImageStreamSpecAssert)this.myself));
    }

    public S hasTags(TagReference ... tags) {
        this.isNotNull();
        if (tags == null) {
            this.failWithMessage("Expecting tags parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, ((ImageStreamSpec)this.actual).getTags(), (Object[])tags);
        return (S)((Object)((AbstractImageStreamSpecAssert)this.myself));
    }

    public S hasOnlyTags(TagReference ... tags) {
        this.isNotNull();
        if (tags == null) {
            this.failWithMessage("Expecting tags parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, ((ImageStreamSpec)this.actual).getTags(), (Object[])tags);
        return (S)((Object)((AbstractImageStreamSpecAssert)this.myself));
    }

    public S doesNotHaveTags(TagReference ... tags) {
        this.isNotNull();
        if (tags == null) {
            this.failWithMessage("Expecting tags parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, ((ImageStreamSpec)this.actual).getTags(), (Object[])tags);
        return (S)((Object)((AbstractImageStreamSpecAssert)this.myself));
    }

    public S hasNoTags() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have tags but had :\n  <%s>";
        if (((ImageStreamSpec)this.actual).getTags().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((ImageStreamSpec)this.actual).getTags()});
        }
        return (S)((Object)((AbstractImageStreamSpecAssert)this.myself));
    }
}

