/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimSpec;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimSpecFluent;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluentImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PersistentVolumeClaimSpecFluentImpl<T extends PersistentVolumeClaimSpecFluent<T>>
extends BaseFluent<T>
implements PersistentVolumeClaimSpecFluent<T> {
    List<String> accessModes = new ArrayList<String>();
    VisitableBuilder<ResourceRequirements, ?> resources;
    String volumeName;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public PersistentVolumeClaimSpecFluentImpl() {
    }

    public PersistentVolumeClaimSpecFluentImpl(PersistentVolumeClaimSpec instance) {
        this.withAccessModes(instance.getAccessModes());
        this.withResources(instance.getResources());
        this.withVolumeName(instance.getVolumeName());
    }

    @Override
    public T addToAccessModes(String ... items) {
        for (String item : items) {
            this.accessModes.add(item);
        }
        return (T)this;
    }

    @Override
    public T removeFromAccessModes(String ... items) {
        for (String item : items) {
            this.accessModes.remove(item);
        }
        return (T)this;
    }

    @Override
    public List<String> getAccessModes() {
        return this.accessModes;
    }

    @Override
    public T withAccessModes(List<String> accessModes) {
        this.accessModes.clear();
        if (accessModes != null) {
            for (String item : accessModes) {
                this.addToAccessModes(item);
            }
        }
        return (T)this;
    }

    @Override
    public T withAccessModes(String ... accessModes) {
        this.accessModes.clear();
        if (accessModes != null) {
            for (String item : accessModes) {
                this.addToAccessModes(item);
            }
        }
        return (T)this;
    }

    @Override
    public ResourceRequirements getResources() {
        return this.resources != null ? (ResourceRequirements)this.resources.build() : null;
    }

    @Override
    public T withResources(ResourceRequirements resources) {
        if (resources != null) {
            this.resources = new ResourceRequirementsBuilder(resources);
            this._visitables.add(this.resources);
        }
        return (T)this;
    }

    @Override
    public PersistentVolumeClaimSpecFluent.ResourcesNested<T> withNewResources() {
        return new ResourcesNestedImpl();
    }

    @Override
    public PersistentVolumeClaimSpecFluent.ResourcesNested<T> withNewResourcesLike(ResourceRequirements item) {
        return new ResourcesNestedImpl(item);
    }

    @Override
    public PersistentVolumeClaimSpecFluent.ResourcesNested<T> editResources() {
        return this.withNewResourcesLike(this.getResources());
    }

    @Override
    public String getVolumeName() {
        return this.volumeName;
    }

    @Override
    public T withVolumeName(String volumeName) {
        this.volumeName = volumeName;
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.additionalProperties.remove(key);
            }
        }
        return (T)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PersistentVolumeClaimSpecFluentImpl that = (PersistentVolumeClaimSpecFluentImpl)o;
        if (this.accessModes != null ? !this.accessModes.equals(that.accessModes) : that.accessModes != null) {
            return false;
        }
        if (this.resources != null ? !this.resources.equals(that.resources) : that.resources != null) {
            return false;
        }
        if (this.volumeName != null ? !this.volumeName.equals(that.volumeName) : that.volumeName != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class ResourcesNestedImpl<N>
    extends ResourceRequirementsFluentImpl<PersistentVolumeClaimSpecFluent.ResourcesNested<N>>
    implements PersistentVolumeClaimSpecFluent.ResourcesNested<N> {
        private final ResourceRequirementsBuilder builder;

        ResourcesNestedImpl() {
            this.builder = new ResourceRequirementsBuilder(this);
        }

        ResourcesNestedImpl(ResourceRequirements item) {
            this.builder = new ResourceRequirementsBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeClaimSpecFluentImpl.this.withResources(this.builder.build());
        }

        @Override
        public N endResources() {
            return this.and();
        }
    }
}

