/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.ContainerPortBuilder;
import io.fabric8.kubernetes.api.model.ContainerPortFluentImpl;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.EnvVarFluentImpl;
import io.fabric8.kubernetes.api.model.Lifecycle;
import io.fabric8.kubernetes.api.model.LifecycleBuilder;
import io.fabric8.kubernetes.api.model.LifecycleFluentImpl;
import io.fabric8.kubernetes.api.model.Probe;
import io.fabric8.kubernetes.api.model.ProbeBuilder;
import io.fabric8.kubernetes.api.model.ProbeFluentImpl;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluentImpl;
import io.fabric8.kubernetes.api.model.SecurityContext;
import io.fabric8.kubernetes.api.model.SecurityContextBuilder;
import io.fabric8.kubernetes.api.model.SecurityContextFluentImpl;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.fabric8.kubernetes.api.model.VolumeMountBuilder;
import io.fabric8.kubernetes.api.model.VolumeMountFluentImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ContainerFluentImpl<T extends ContainerFluent<T>>
extends BaseFluent<T>
implements ContainerFluent<T> {
    List<String> args = new ArrayList<String>();
    List<String> command = new ArrayList<String>();
    List<VisitableBuilder<EnvVar, ?>> env = new ArrayList();
    String image;
    String imagePullPolicy;
    VisitableBuilder<Lifecycle, ?> lifecycle;
    VisitableBuilder<Probe, ?> livenessProbe;
    String name;
    List<VisitableBuilder<ContainerPort, ?>> ports = new ArrayList();
    VisitableBuilder<Probe, ?> readinessProbe;
    VisitableBuilder<ResourceRequirements, ?> resources;
    VisitableBuilder<SecurityContext, ?> securityContext;
    Boolean stdin;
    Boolean stdinOnce;
    String terminationMessagePath;
    Boolean tty;
    List<VisitableBuilder<VolumeMount, ?>> volumeMounts = new ArrayList();
    String workingDir;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public ContainerFluentImpl() {
    }

    public ContainerFluentImpl(Container instance) {
        this.withArgs(instance.getArgs());
        this.withCommand(instance.getCommand());
        this.withEnv(instance.getEnv());
        this.withImage(instance.getImage());
        this.withImagePullPolicy(instance.getImagePullPolicy());
        this.withLifecycle(instance.getLifecycle());
        this.withLivenessProbe(instance.getLivenessProbe());
        this.withName(instance.getName());
        this.withPorts(instance.getPorts());
        this.withReadinessProbe(instance.getReadinessProbe());
        this.withResources(instance.getResources());
        this.withSecurityContext(instance.getSecurityContext());
        this.withStdin(instance.getStdin());
        this.withStdinOnce(instance.getStdinOnce());
        this.withTerminationMessagePath(instance.getTerminationMessagePath());
        this.withTty(instance.getTty());
        this.withVolumeMounts(instance.getVolumeMounts());
        this.withWorkingDir(instance.getWorkingDir());
    }

    @Override
    public T addToArgs(String ... items) {
        for (String item : items) {
            this.args.add(item);
        }
        return (T)this;
    }

    @Override
    public T removeFromArgs(String ... items) {
        for (String item : items) {
            this.args.remove(item);
        }
        return (T)this;
    }

    @Override
    public List<String> getArgs() {
        return this.args;
    }

    @Override
    public T withArgs(List<String> args) {
        this.args.clear();
        if (args != null) {
            for (String item : args) {
                this.addToArgs(item);
            }
        }
        return (T)this;
    }

    @Override
    public T withArgs(String ... args) {
        this.args.clear();
        if (args != null) {
            for (String item : args) {
                this.addToArgs(item);
            }
        }
        return (T)this;
    }

    @Override
    public T addToCommand(String ... items) {
        for (String item : items) {
            this.command.add(item);
        }
        return (T)this;
    }

    @Override
    public T removeFromCommand(String ... items) {
        for (String item : items) {
            this.command.remove(item);
        }
        return (T)this;
    }

    @Override
    public List<String> getCommand() {
        return this.command;
    }

    @Override
    public T withCommand(List<String> command) {
        this.command.clear();
        if (command != null) {
            for (String item : command) {
                this.addToCommand(item);
            }
        }
        return (T)this;
    }

    @Override
    public T withCommand(String ... command) {
        this.command.clear();
        if (command != null) {
            for (String item : command) {
                this.addToCommand(item);
            }
        }
        return (T)this;
    }

    @Override
    public T addToEnv(EnvVar ... items) {
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.add(builder);
            this.env.add(builder);
        }
        return (T)this;
    }

    @Override
    public T removeFromEnv(EnvVar ... items) {
        for (EnvVar item : items) {
            EnvVarBuilder builder = new EnvVarBuilder(item);
            this._visitables.remove(builder);
            this.env.remove(builder);
        }
        return (T)this;
    }

    @Override
    public List<EnvVar> getEnv() {
        return this.build(this.env);
    }

    @Override
    public T withEnv(List<EnvVar> env) {
        this.env.clear();
        if (env != null) {
            for (EnvVar item : env) {
                this.addToEnv(item);
            }
        }
        return (T)this;
    }

    @Override
    public T withEnv(EnvVar ... env) {
        this.env.clear();
        if (env != null) {
            for (EnvVar item : env) {
                this.addToEnv(item);
            }
        }
        return (T)this;
    }

    @Override
    public ContainerFluent.EnvNested<T> addNewEnv() {
        return new EnvNestedImpl();
    }

    @Override
    public ContainerFluent.EnvNested<T> addNewEnvLike(EnvVar item) {
        return new EnvNestedImpl(item);
    }

    @Override
    public String getImage() {
        return this.image;
    }

    @Override
    public T withImage(String image) {
        this.image = image;
        return (T)this;
    }

    @Override
    public String getImagePullPolicy() {
        return this.imagePullPolicy;
    }

    @Override
    public T withImagePullPolicy(String imagePullPolicy) {
        this.imagePullPolicy = imagePullPolicy;
        return (T)this;
    }

    @Override
    public Lifecycle getLifecycle() {
        return this.lifecycle != null ? (Lifecycle)this.lifecycle.build() : null;
    }

    @Override
    public T withLifecycle(Lifecycle lifecycle) {
        if (lifecycle != null) {
            this.lifecycle = new LifecycleBuilder(lifecycle);
            this._visitables.add(this.lifecycle);
        }
        return (T)this;
    }

    @Override
    public ContainerFluent.LifecycleNested<T> withNewLifecycle() {
        return new LifecycleNestedImpl();
    }

    @Override
    public ContainerFluent.LifecycleNested<T> withNewLifecycleLike(Lifecycle item) {
        return new LifecycleNestedImpl(item);
    }

    @Override
    public ContainerFluent.LifecycleNested<T> editLifecycle() {
        return this.withNewLifecycleLike(this.getLifecycle());
    }

    @Override
    public Probe getLivenessProbe() {
        return this.livenessProbe != null ? (Probe)this.livenessProbe.build() : null;
    }

    @Override
    public T withLivenessProbe(Probe livenessProbe) {
        if (livenessProbe != null) {
            this.livenessProbe = new ProbeBuilder(livenessProbe);
            this._visitables.add(this.livenessProbe);
        }
        return (T)this;
    }

    @Override
    public ContainerFluent.LivenessProbeNested<T> withNewLivenessProbe() {
        return new LivenessProbeNestedImpl();
    }

    @Override
    public ContainerFluent.LivenessProbeNested<T> withNewLivenessProbeLike(Probe item) {
        return new LivenessProbeNestedImpl(item);
    }

    @Override
    public ContainerFluent.LivenessProbeNested<T> editLivenessProbe() {
        return this.withNewLivenessProbeLike(this.getLivenessProbe());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public T withName(String name) {
        this.name = name;
        return (T)this;
    }

    @Override
    public T addToPorts(ContainerPort ... items) {
        for (ContainerPort item : items) {
            ContainerPortBuilder builder = new ContainerPortBuilder(item);
            this._visitables.add(builder);
            this.ports.add(builder);
        }
        return (T)this;
    }

    @Override
    public T removeFromPorts(ContainerPort ... items) {
        for (ContainerPort item : items) {
            ContainerPortBuilder builder = new ContainerPortBuilder(item);
            this._visitables.remove(builder);
            this.ports.remove(builder);
        }
        return (T)this;
    }

    @Override
    public List<ContainerPort> getPorts() {
        return this.build(this.ports);
    }

    @Override
    public T withPorts(List<ContainerPort> ports) {
        this.ports.clear();
        if (ports != null) {
            for (ContainerPort item : ports) {
                this.addToPorts(item);
            }
        }
        return (T)this;
    }

    @Override
    public T withPorts(ContainerPort ... ports) {
        this.ports.clear();
        if (ports != null) {
            for (ContainerPort item : ports) {
                this.addToPorts(item);
            }
        }
        return (T)this;
    }

    @Override
    public ContainerFluent.PortsNested<T> addNewPort() {
        return new PortsNestedImpl();
    }

    @Override
    public ContainerFluent.PortsNested<T> addNewPortLike(ContainerPort item) {
        return new PortsNestedImpl(item);
    }

    @Override
    public T addNewPort(Integer containerPort, String hostIP, Integer hostPort, String name, String protocol) {
        return this.addToPorts(new ContainerPort(containerPort, hostIP, hostPort, name, protocol));
    }

    @Override
    public Probe getReadinessProbe() {
        return this.readinessProbe != null ? (Probe)this.readinessProbe.build() : null;
    }

    @Override
    public T withReadinessProbe(Probe readinessProbe) {
        if (readinessProbe != null) {
            this.readinessProbe = new ProbeBuilder(readinessProbe);
            this._visitables.add(this.readinessProbe);
        }
        return (T)this;
    }

    @Override
    public ContainerFluent.ReadinessProbeNested<T> withNewReadinessProbe() {
        return new ReadinessProbeNestedImpl();
    }

    @Override
    public ContainerFluent.ReadinessProbeNested<T> withNewReadinessProbeLike(Probe item) {
        return new ReadinessProbeNestedImpl(item);
    }

    @Override
    public ContainerFluent.ReadinessProbeNested<T> editReadinessProbe() {
        return this.withNewReadinessProbeLike(this.getReadinessProbe());
    }

    @Override
    public ResourceRequirements getResources() {
        return this.resources != null ? (ResourceRequirements)this.resources.build() : null;
    }

    @Override
    public T withResources(ResourceRequirements resources) {
        if (resources != null) {
            this.resources = new ResourceRequirementsBuilder(resources);
            this._visitables.add(this.resources);
        }
        return (T)this;
    }

    @Override
    public ContainerFluent.ResourcesNested<T> withNewResources() {
        return new ResourcesNestedImpl();
    }

    @Override
    public ContainerFluent.ResourcesNested<T> withNewResourcesLike(ResourceRequirements item) {
        return new ResourcesNestedImpl(item);
    }

    @Override
    public ContainerFluent.ResourcesNested<T> editResources() {
        return this.withNewResourcesLike(this.getResources());
    }

    @Override
    public SecurityContext getSecurityContext() {
        return this.securityContext != null ? (SecurityContext)this.securityContext.build() : null;
    }

    @Override
    public T withSecurityContext(SecurityContext securityContext) {
        if (securityContext != null) {
            this.securityContext = new SecurityContextBuilder(securityContext);
            this._visitables.add(this.securityContext);
        }
        return (T)this;
    }

    @Override
    public ContainerFluent.SecurityContextNested<T> withNewSecurityContext() {
        return new SecurityContextNestedImpl();
    }

    @Override
    public ContainerFluent.SecurityContextNested<T> withNewSecurityContextLike(SecurityContext item) {
        return new SecurityContextNestedImpl(item);
    }

    @Override
    public ContainerFluent.SecurityContextNested<T> editSecurityContext() {
        return this.withNewSecurityContextLike(this.getSecurityContext());
    }

    @Override
    public Boolean isStdin() {
        return this.stdin;
    }

    @Override
    public T withStdin(Boolean stdin) {
        this.stdin = stdin;
        return (T)this;
    }

    @Override
    public Boolean isStdinOnce() {
        return this.stdinOnce;
    }

    @Override
    public T withStdinOnce(Boolean stdinOnce) {
        this.stdinOnce = stdinOnce;
        return (T)this;
    }

    @Override
    public String getTerminationMessagePath() {
        return this.terminationMessagePath;
    }

    @Override
    public T withTerminationMessagePath(String terminationMessagePath) {
        this.terminationMessagePath = terminationMessagePath;
        return (T)this;
    }

    @Override
    public Boolean isTty() {
        return this.tty;
    }

    @Override
    public T withTty(Boolean tty) {
        this.tty = tty;
        return (T)this;
    }

    @Override
    public T addToVolumeMounts(VolumeMount ... items) {
        for (VolumeMount item : items) {
            VolumeMountBuilder builder = new VolumeMountBuilder(item);
            this._visitables.add(builder);
            this.volumeMounts.add(builder);
        }
        return (T)this;
    }

    @Override
    public T removeFromVolumeMounts(VolumeMount ... items) {
        for (VolumeMount item : items) {
            VolumeMountBuilder builder = new VolumeMountBuilder(item);
            this._visitables.remove(builder);
            this.volumeMounts.remove(builder);
        }
        return (T)this;
    }

    @Override
    public List<VolumeMount> getVolumeMounts() {
        return this.build(this.volumeMounts);
    }

    @Override
    public T withVolumeMounts(List<VolumeMount> volumeMounts) {
        this.volumeMounts.clear();
        if (volumeMounts != null) {
            for (VolumeMount item : volumeMounts) {
                this.addToVolumeMounts(item);
            }
        }
        return (T)this;
    }

    @Override
    public T withVolumeMounts(VolumeMount ... volumeMounts) {
        this.volumeMounts.clear();
        if (volumeMounts != null) {
            for (VolumeMount item : volumeMounts) {
                this.addToVolumeMounts(item);
            }
        }
        return (T)this;
    }

    @Override
    public ContainerFluent.VolumeMountsNested<T> addNewVolumeMount() {
        return new VolumeMountsNestedImpl();
    }

    @Override
    public ContainerFluent.VolumeMountsNested<T> addNewVolumeMountLike(VolumeMount item) {
        return new VolumeMountsNestedImpl(item);
    }

    @Override
    public T addNewVolumeMount(String mountPath, String name, Boolean readOnly) {
        return this.addToVolumeMounts(new VolumeMount(mountPath, name, readOnly));
    }

    @Override
    public String getWorkingDir() {
        return this.workingDir;
    }

    @Override
    public T withWorkingDir(String workingDir) {
        this.workingDir = workingDir;
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.additionalProperties.remove(key);
            }
        }
        return (T)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContainerFluentImpl that = (ContainerFluentImpl)o;
        if (this.args != null ? !this.args.equals(that.args) : that.args != null) {
            return false;
        }
        if (this.command != null ? !this.command.equals(that.command) : that.command != null) {
            return false;
        }
        if (this.env != null ? !this.env.equals(that.env) : that.env != null) {
            return false;
        }
        if (this.image != null ? !this.image.equals(that.image) : that.image != null) {
            return false;
        }
        if (this.imagePullPolicy != null ? !this.imagePullPolicy.equals(that.imagePullPolicy) : that.imagePullPolicy != null) {
            return false;
        }
        if (this.lifecycle != null ? !this.lifecycle.equals(that.lifecycle) : that.lifecycle != null) {
            return false;
        }
        if (this.livenessProbe != null ? !this.livenessProbe.equals(that.livenessProbe) : that.livenessProbe != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.ports != null ? !this.ports.equals(that.ports) : that.ports != null) {
            return false;
        }
        if (this.readinessProbe != null ? !this.readinessProbe.equals(that.readinessProbe) : that.readinessProbe != null) {
            return false;
        }
        if (this.resources != null ? !this.resources.equals(that.resources) : that.resources != null) {
            return false;
        }
        if (this.securityContext != null ? !this.securityContext.equals(that.securityContext) : that.securityContext != null) {
            return false;
        }
        if (this.stdin != null ? !this.stdin.equals(that.stdin) : that.stdin != null) {
            return false;
        }
        if (this.stdinOnce != null ? !this.stdinOnce.equals(that.stdinOnce) : that.stdinOnce != null) {
            return false;
        }
        if (this.terminationMessagePath != null ? !this.terminationMessagePath.equals(that.terminationMessagePath) : that.terminationMessagePath != null) {
            return false;
        }
        if (this.tty != null ? !this.tty.equals(that.tty) : that.tty != null) {
            return false;
        }
        if (this.volumeMounts != null ? !this.volumeMounts.equals(that.volumeMounts) : that.volumeMounts != null) {
            return false;
        }
        if (this.workingDir != null ? !this.workingDir.equals(that.workingDir) : that.workingDir != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class VolumeMountsNestedImpl<N>
    extends VolumeMountFluentImpl<ContainerFluent.VolumeMountsNested<N>>
    implements ContainerFluent.VolumeMountsNested<N> {
        private final VolumeMountBuilder builder;

        VolumeMountsNestedImpl() {
            this.builder = new VolumeMountBuilder(this);
        }

        VolumeMountsNestedImpl(VolumeMount item) {
            this.builder = new VolumeMountBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ContainerFluentImpl.this.addToVolumeMounts(this.builder.build());
        }

        @Override
        public N endVolumeMount() {
            return this.and();
        }
    }

    public class SecurityContextNestedImpl<N>
    extends SecurityContextFluentImpl<ContainerFluent.SecurityContextNested<N>>
    implements ContainerFluent.SecurityContextNested<N> {
        private final SecurityContextBuilder builder;

        SecurityContextNestedImpl() {
            this.builder = new SecurityContextBuilder(this);
        }

        SecurityContextNestedImpl(SecurityContext item) {
            this.builder = new SecurityContextBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ContainerFluentImpl.this.withSecurityContext(this.builder.build());
        }

        @Override
        public N endSecurityContext() {
            return this.and();
        }
    }

    public class ResourcesNestedImpl<N>
    extends ResourceRequirementsFluentImpl<ContainerFluent.ResourcesNested<N>>
    implements ContainerFluent.ResourcesNested<N> {
        private final ResourceRequirementsBuilder builder;

        ResourcesNestedImpl() {
            this.builder = new ResourceRequirementsBuilder(this);
        }

        ResourcesNestedImpl(ResourceRequirements item) {
            this.builder = new ResourceRequirementsBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ContainerFluentImpl.this.withResources(this.builder.build());
        }

        @Override
        public N endResources() {
            return this.and();
        }
    }

    public class ReadinessProbeNestedImpl<N>
    extends ProbeFluentImpl<ContainerFluent.ReadinessProbeNested<N>>
    implements ContainerFluent.ReadinessProbeNested<N> {
        private final ProbeBuilder builder;

        ReadinessProbeNestedImpl() {
            this.builder = new ProbeBuilder(this);
        }

        ReadinessProbeNestedImpl(Probe item) {
            this.builder = new ProbeBuilder(this, item);
        }

        @Override
        public N endReadinessProbe() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)ContainerFluentImpl.this.withReadinessProbe(this.builder.build());
        }
    }

    public class PortsNestedImpl<N>
    extends ContainerPortFluentImpl<ContainerFluent.PortsNested<N>>
    implements ContainerFluent.PortsNested<N> {
        private final ContainerPortBuilder builder;

        PortsNestedImpl() {
            this.builder = new ContainerPortBuilder(this);
        }

        PortsNestedImpl(ContainerPort item) {
            this.builder = new ContainerPortBuilder(this, item);
        }

        @Override
        public N endPort() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)ContainerFluentImpl.this.addToPorts(this.builder.build());
        }
    }

    public class LivenessProbeNestedImpl<N>
    extends ProbeFluentImpl<ContainerFluent.LivenessProbeNested<N>>
    implements ContainerFluent.LivenessProbeNested<N> {
        private final ProbeBuilder builder;

        LivenessProbeNestedImpl() {
            this.builder = new ProbeBuilder(this);
        }

        LivenessProbeNestedImpl(Probe item) {
            this.builder = new ProbeBuilder(this, item);
        }

        @Override
        public N endLivenessProbe() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)ContainerFluentImpl.this.withLivenessProbe(this.builder.build());
        }
    }

    public class LifecycleNestedImpl<N>
    extends LifecycleFluentImpl<ContainerFluent.LifecycleNested<N>>
    implements ContainerFluent.LifecycleNested<N> {
        private final LifecycleBuilder builder;

        LifecycleNestedImpl() {
            this.builder = new LifecycleBuilder(this);
        }

        LifecycleNestedImpl(Lifecycle item) {
            this.builder = new LifecycleBuilder(this, item);
        }

        @Override
        public N endLifecycle() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)ContainerFluentImpl.this.withLifecycle(this.builder.build());
        }
    }

    public class EnvNestedImpl<N>
    extends EnvVarFluentImpl<ContainerFluent.EnvNested<N>>
    implements ContainerFluent.EnvNested<N> {
        private final EnvVarBuilder builder;

        EnvNestedImpl() {
            this.builder = new EnvVarBuilder(this);
        }

        EnvNestedImpl(EnvVar item) {
            this.builder = new EnvVarBuilder(this, item);
        }

        @Override
        public N endEnv() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)ContainerFluentImpl.this.addToEnv(this.builder.build());
        }
    }
}

