/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServiceSpecFluent;
import java.util.Map;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

public abstract class AbstractServiceSpecFluentAssert<S extends AbstractServiceSpecFluentAssert<S, A>, A extends ServiceSpecFluent>
extends AbstractAssert<S, A> {
    protected AbstractServiceSpecFluentAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public S hasAdditionalProperties(Map additionalProperties) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Map<String, Object> actualAdditionalProperties = ((ServiceSpecFluent)this.actual).getAdditionalProperties();
        if (!Objects.areEqual(actualAdditionalProperties, (Object)additionalProperties)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, additionalProperties, actualAdditionalProperties});
        }
        return (S)((Object)((AbstractServiceSpecFluentAssert)this.myself));
    }

    public S hasClusterIP(String clusterIP) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting clusterIP of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualClusterIP = ((ServiceSpecFluent)this.actual).getClusterIP();
        if (!Objects.areEqual((Object)actualClusterIP, (Object)clusterIP)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, clusterIP, actualClusterIP});
        }
        return (S)((Object)((AbstractServiceSpecFluentAssert)this.myself));
    }

    public S hasDeprecatedPublicIPs(String ... deprecatedPublicIPs) {
        this.isNotNull();
        if (deprecatedPublicIPs == null) {
            this.failWithMessage("Expecting deprecatedPublicIPs parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, ((ServiceSpecFluent)this.actual).getDeprecatedPublicIPs(), (Object[])deprecatedPublicIPs);
        return (S)((Object)((AbstractServiceSpecFluentAssert)this.myself));
    }

    public S hasOnlyDeprecatedPublicIPs(String ... deprecatedPublicIPs) {
        this.isNotNull();
        if (deprecatedPublicIPs == null) {
            this.failWithMessage("Expecting deprecatedPublicIPs parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, ((ServiceSpecFluent)this.actual).getDeprecatedPublicIPs(), (Object[])deprecatedPublicIPs);
        return (S)((Object)((AbstractServiceSpecFluentAssert)this.myself));
    }

    public S doesNotHaveDeprecatedPublicIPs(String ... deprecatedPublicIPs) {
        this.isNotNull();
        if (deprecatedPublicIPs == null) {
            this.failWithMessage("Expecting deprecatedPublicIPs parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, ((ServiceSpecFluent)this.actual).getDeprecatedPublicIPs(), (Object[])deprecatedPublicIPs);
        return (S)((Object)((AbstractServiceSpecFluentAssert)this.myself));
    }

    public S hasNoDeprecatedPublicIPs() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have deprecatedPublicIPs but had :\n  <%s>";
        if (((ServiceSpecFluent)this.actual).getDeprecatedPublicIPs().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((ServiceSpecFluent)this.actual).getDeprecatedPublicIPs()});
        }
        return (S)((Object)((AbstractServiceSpecFluentAssert)this.myself));
    }

    public S hasExternalIPs(String ... externalIPs) {
        this.isNotNull();
        if (externalIPs == null) {
            this.failWithMessage("Expecting externalIPs parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, ((ServiceSpecFluent)this.actual).getExternalIPs(), (Object[])externalIPs);
        return (S)((Object)((AbstractServiceSpecFluentAssert)this.myself));
    }

    public S hasOnlyExternalIPs(String ... externalIPs) {
        this.isNotNull();
        if (externalIPs == null) {
            this.failWithMessage("Expecting externalIPs parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, ((ServiceSpecFluent)this.actual).getExternalIPs(), (Object[])externalIPs);
        return (S)((Object)((AbstractServiceSpecFluentAssert)this.myself));
    }

    public S doesNotHaveExternalIPs(String ... externalIPs) {
        this.isNotNull();
        if (externalIPs == null) {
            this.failWithMessage("Expecting externalIPs parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, ((ServiceSpecFluent)this.actual).getExternalIPs(), (Object[])externalIPs);
        return (S)((Object)((AbstractServiceSpecFluentAssert)this.myself));
    }

    public S hasNoExternalIPs() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have externalIPs but had :\n  <%s>";
        if (((ServiceSpecFluent)this.actual).getExternalIPs().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((ServiceSpecFluent)this.actual).getExternalIPs()});
        }
        return (S)((Object)((AbstractServiceSpecFluentAssert)this.myself));
    }

    public S hasLoadBalancerIP(String loadBalancerIP) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting loadBalancerIP of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualLoadBalancerIP = ((ServiceSpecFluent)this.actual).getLoadBalancerIP();
        if (!Objects.areEqual((Object)actualLoadBalancerIP, (Object)loadBalancerIP)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, loadBalancerIP, actualLoadBalancerIP});
        }
        return (S)((Object)((AbstractServiceSpecFluentAssert)this.myself));
    }

    public S hasPortalIP(String portalIP) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting portalIP of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualPortalIP = ((ServiceSpecFluent)this.actual).getPortalIP();
        if (!Objects.areEqual((Object)actualPortalIP, (Object)portalIP)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, portalIP, actualPortalIP});
        }
        return (S)((Object)((AbstractServiceSpecFluentAssert)this.myself));
    }

    public S hasPorts(ServicePort ... ports) {
        this.isNotNull();
        if (ports == null) {
            this.failWithMessage("Expecting ports parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, ((ServiceSpecFluent)this.actual).getPorts(), (Object[])ports);
        return (S)((Object)((AbstractServiceSpecFluentAssert)this.myself));
    }

    public S hasOnlyPorts(ServicePort ... ports) {
        this.isNotNull();
        if (ports == null) {
            this.failWithMessage("Expecting ports parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, ((ServiceSpecFluent)this.actual).getPorts(), (Object[])ports);
        return (S)((Object)((AbstractServiceSpecFluentAssert)this.myself));
    }

    public S doesNotHavePorts(ServicePort ... ports) {
        this.isNotNull();
        if (ports == null) {
            this.failWithMessage("Expecting ports parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, ((ServiceSpecFluent)this.actual).getPorts(), (Object[])ports);
        return (S)((Object)((AbstractServiceSpecFluentAssert)this.myself));
    }

    public S hasNoPorts() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have ports but had :\n  <%s>";
        if (((ServiceSpecFluent)this.actual).getPorts().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((ServiceSpecFluent)this.actual).getPorts()});
        }
        return (S)((Object)((AbstractServiceSpecFluentAssert)this.myself));
    }

    public S hasSelector(Map selector) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting selector of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Map<String, String> actualSelector = ((ServiceSpecFluent)this.actual).getSelector();
        if (!Objects.areEqual(actualSelector, (Object)selector)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, selector, actualSelector});
        }
        return (S)((Object)((AbstractServiceSpecFluentAssert)this.myself));
    }

    public S hasSessionAffinity(String sessionAffinity) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting sessionAffinity of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualSessionAffinity = ((ServiceSpecFluent)this.actual).getSessionAffinity();
        if (!Objects.areEqual((Object)actualSessionAffinity, (Object)sessionAffinity)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, sessionAffinity, actualSessionAffinity});
        }
        return (S)((Object)((AbstractServiceSpecFluentAssert)this.myself));
    }

    public S hasType(String type) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting type of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualType = ((ServiceSpecFluent)this.actual).getType();
        if (!Objects.areEqual((Object)actualType, (Object)type)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, type, actualType});
        }
        return (S)((Object)((AbstractServiceSpecFluentAssert)this.myself));
    }
}

