/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.Cluster;
import io.fabric8.kubernetes.api.model.ClusterFluent;
import io.fabric8.kubernetes.api.model.NamedExtension;
import io.fabric8.kubernetes.api.model.NamedExtensionBuilder;
import io.fabric8.kubernetes.api.model.NamedExtensionFluentImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ClusterFluentImpl<T extends ClusterFluent<T>>
extends BaseFluent<T>
implements ClusterFluent<T> {
    String apiVersion;
    String certificateAuthority;
    String certificateAuthorityData;
    List<VisitableBuilder<NamedExtension, ?>> extensions = new ArrayList();
    Boolean insecureSkipTlsVerify;
    String server;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public ClusterFluentImpl() {
    }

    public ClusterFluentImpl(Cluster instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withCertificateAuthority(instance.getCertificateAuthority());
        this.withCertificateAuthorityData(instance.getCertificateAuthorityData());
        this.withExtensions(instance.getExtensions());
        this.withInsecureSkipTlsVerify(instance.getInsecureSkipTlsVerify());
        this.withServer(instance.getServer());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public T withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (T)this;
    }

    @Override
    public String getCertificateAuthority() {
        return this.certificateAuthority;
    }

    @Override
    public T withCertificateAuthority(String certificateAuthority) {
        this.certificateAuthority = certificateAuthority;
        return (T)this;
    }

    @Override
    public String getCertificateAuthorityData() {
        return this.certificateAuthorityData;
    }

    @Override
    public T withCertificateAuthorityData(String certificateAuthorityData) {
        this.certificateAuthorityData = certificateAuthorityData;
        return (T)this;
    }

    @Override
    public T addToExtensions(NamedExtension ... items) {
        for (NamedExtension item : items) {
            NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
            this._visitables.add(builder);
            this.extensions.add(builder);
        }
        return (T)this;
    }

    @Override
    public T removeFromExtensions(NamedExtension ... items) {
        for (NamedExtension item : items) {
            NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
            this._visitables.remove(builder);
            this.extensions.remove(builder);
        }
        return (T)this;
    }

    @Override
    public List<NamedExtension> getExtensions() {
        return this.build(this.extensions);
    }

    @Override
    public T withExtensions(List<NamedExtension> extensions) {
        this.extensions.clear();
        if (extensions != null) {
            for (NamedExtension item : extensions) {
                this.addToExtensions(item);
            }
        }
        return (T)this;
    }

    @Override
    public T withExtensions(NamedExtension ... extensions) {
        this.extensions.clear();
        if (extensions != null) {
            for (NamedExtension item : extensions) {
                this.addToExtensions(item);
            }
        }
        return (T)this;
    }

    @Override
    public ClusterFluent.ExtensionsNested<T> addNewExtension() {
        return new ExtensionsNestedImpl();
    }

    @Override
    public ClusterFluent.ExtensionsNested<T> addNewExtensionLike(NamedExtension item) {
        return new ExtensionsNestedImpl(item);
    }

    @Override
    public Boolean isInsecureSkipTlsVerify() {
        return this.insecureSkipTlsVerify;
    }

    @Override
    public T withInsecureSkipTlsVerify(Boolean insecureSkipTlsVerify) {
        this.insecureSkipTlsVerify = insecureSkipTlsVerify;
        return (T)this;
    }

    @Override
    public String getServer() {
        return this.server;
    }

    @Override
    public T withServer(String server) {
        this.server = server;
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.additionalProperties.remove(key);
            }
        }
        return (T)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterFluentImpl that = (ClusterFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.certificateAuthority != null ? !this.certificateAuthority.equals(that.certificateAuthority) : that.certificateAuthority != null) {
            return false;
        }
        if (this.certificateAuthorityData != null ? !this.certificateAuthorityData.equals(that.certificateAuthorityData) : that.certificateAuthorityData != null) {
            return false;
        }
        if (this.extensions != null ? !this.extensions.equals(that.extensions) : that.extensions != null) {
            return false;
        }
        if (this.insecureSkipTlsVerify != null ? !this.insecureSkipTlsVerify.equals(that.insecureSkipTlsVerify) : that.insecureSkipTlsVerify != null) {
            return false;
        }
        if (this.server != null ? !this.server.equals(that.server) : that.server != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class ExtensionsNestedImpl<N>
    extends NamedExtensionFluentImpl<ClusterFluent.ExtensionsNested<N>>
    implements ClusterFluent.ExtensionsNested<N> {
        private final NamedExtensionBuilder builder;

        ExtensionsNestedImpl(NamedExtension item) {
            this.builder = new NamedExtensionBuilder(this, item);
        }

        ExtensionsNestedImpl() {
            this.builder = new NamedExtensionBuilder(this);
        }

        @Override
        public N and() {
            return (N)ClusterFluentImpl.this.addToExtensions(this.builder.build());
        }

        @Override
        public N endExtension() {
            return this.and();
        }
    }
}

