/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.BinaryBuildSource;
import io.fabric8.openshift.api.model.BinaryBuildSourceFluent;
import io.fabric8.openshift.api.model.BinaryBuildSourceFluentImpl;
import io.fabric8.openshift.api.model.EditableBinaryBuildSource;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class BinaryBuildSourceBuilder
extends BinaryBuildSourceFluentImpl<BinaryBuildSourceBuilder>
implements VisitableBuilder<BinaryBuildSource, BinaryBuildSourceBuilder> {
    BinaryBuildSourceFluent<?> fluent;

    public BinaryBuildSourceBuilder() {
        this(new BinaryBuildSource());
    }

    public BinaryBuildSourceBuilder(BinaryBuildSourceFluent<?> fluent) {
        this(fluent, new BinaryBuildSource());
    }

    public BinaryBuildSourceBuilder(BinaryBuildSourceFluent<?> fluent, BinaryBuildSource instance) {
        this.fluent = fluent;
        fluent.withAsFile(instance.getAsFile());
    }

    public BinaryBuildSourceBuilder(BinaryBuildSource instance) {
        this.fluent = this;
        this.withAsFile(instance.getAsFile());
    }

    public EditableBinaryBuildSource build() {
        EditableBinaryBuildSource buildable = new EditableBinaryBuildSource(this.fluent.getAsFile());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BinaryBuildSourceBuilder that = (BinaryBuildSourceBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

