/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.EditableSecretVolumeSource;
import io.fabric8.kubernetes.api.model.SecretVolumeSource;
import io.fabric8.kubernetes.api.model.SecretVolumeSourceFluent;
import io.fabric8.kubernetes.api.model.SecretVolumeSourceFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class SecretVolumeSourceBuilder
extends SecretVolumeSourceFluentImpl<SecretVolumeSourceBuilder>
implements VisitableBuilder<SecretVolumeSource, SecretVolumeSourceBuilder> {
    SecretVolumeSourceFluent<?> fluent;

    public SecretVolumeSourceBuilder() {
        this(new SecretVolumeSource());
    }

    public SecretVolumeSourceBuilder(SecretVolumeSourceFluent<?> fluent) {
        this(fluent, new SecretVolumeSource());
    }

    public SecretVolumeSourceBuilder(SecretVolumeSourceFluent<?> fluent, SecretVolumeSource instance) {
        this.fluent = fluent;
        fluent.withSecretName(instance.getSecretName());
    }

    public SecretVolumeSourceBuilder(SecretVolumeSource instance) {
        this.fluent = this;
        this.withSecretName(instance.getSecretName());
    }

    public EditableSecretVolumeSource build() {
        EditableSecretVolumeSource buildable = new EditableSecretVolumeSource(this.fluent.getSecretName());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SecretVolumeSourceBuilder that = (SecretVolumeSourceBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

