/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.IntOrStringBuilder;
import io.fabric8.kubernetes.api.model.IntOrStringFluentImpl;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServicePortFluent;
import java.util.HashMap;
import java.util.Map;

public class ServicePortFluentImpl<T extends ServicePortFluent<T>>
extends BaseFluent<T>
implements ServicePortFluent<T> {
    String name;
    Integer nodePort;
    Integer port;
    String protocol;
    VisitableBuilder<IntOrString, ?> targetPort;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public ServicePortFluentImpl() {
    }

    public ServicePortFluentImpl(ServicePort instance) {
        this.withName(instance.getName());
        this.withNodePort(instance.getNodePort());
        this.withPort(instance.getPort());
        this.withProtocol(instance.getProtocol());
        this.withTargetPort(instance.getTargetPort());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public T withName(String name) {
        this.name = name;
        return (T)this;
    }

    @Override
    public Integer getNodePort() {
        return this.nodePort;
    }

    @Override
    public T withNodePort(Integer nodePort) {
        this.nodePort = nodePort;
        return (T)this;
    }

    @Override
    public Integer getPort() {
        return this.port;
    }

    @Override
    public T withPort(Integer port) {
        this.port = port;
        return (T)this;
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public T withProtocol(String protocol) {
        this.protocol = protocol;
        return (T)this;
    }

    @Override
    public IntOrString getTargetPort() {
        return this.targetPort != null ? (IntOrString)this.targetPort.build() : null;
    }

    @Override
    public T withTargetPort(IntOrString targetPort) {
        if (targetPort != null) {
            this.targetPort = new IntOrStringBuilder(targetPort);
            this._visitables.add(this.targetPort);
        }
        return (T)this;
    }

    @Override
    public ServicePortFluent.TargetPortNested<T> withNewTargetPort() {
        return new TargetPortNestedImpl();
    }

    @Override
    public ServicePortFluent.TargetPortNested<T> withNewTargetPortLike(IntOrString item) {
        return new TargetPortNestedImpl(item);
    }

    @Override
    public ServicePortFluent.TargetPortNested<T> editTargetPort() {
        return this.withNewTargetPortLike(this.getTargetPort());
    }

    @Override
    public T withNewTargetPort(String strVal) {
        return this.withTargetPort(new IntOrString(strVal));
    }

    @Override
    public T withNewTargetPort(Integer intVal) {
        return this.withTargetPort(new IntOrString(intVal));
    }

    @Override
    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.additionalProperties.remove(key);
            }
        }
        return (T)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServicePortFluentImpl that = (ServicePortFluentImpl)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.nodePort != null ? !this.nodePort.equals(that.nodePort) : that.nodePort != null) {
            return false;
        }
        if (this.port != null ? !this.port.equals(that.port) : that.port != null) {
            return false;
        }
        if (this.protocol != null ? !this.protocol.equals(that.protocol) : that.protocol != null) {
            return false;
        }
        if (this.targetPort != null ? !this.targetPort.equals(that.targetPort) : that.targetPort != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class TargetPortNestedImpl<N>
    extends IntOrStringFluentImpl<ServicePortFluent.TargetPortNested<N>>
    implements ServicePortFluent.TargetPortNested<N> {
        private final IntOrStringBuilder builder;

        TargetPortNestedImpl() {
            this.builder = new IntOrStringBuilder(this);
        }

        TargetPortNestedImpl(IntOrString item) {
            this.builder = new IntOrStringBuilder(this, item);
        }

        @Override
        public N endTargetPort() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)ServicePortFluentImpl.this.withTargetPort(this.builder.build());
        }
    }
}

