/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.openshift.api.model.OAuthClient;
import java.util.Map;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

public abstract class AbstractOAuthClientAssert<S extends AbstractOAuthClientAssert<S, A>, A extends OAuthClient>
extends AbstractAssert<S, A> {
    protected AbstractOAuthClientAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public S hasAdditionalProperties(Map additionalProperties) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Map<String, Object> actualAdditionalProperties = ((OAuthClient)this.actual).getAdditionalProperties();
        if (!Objects.areEqual(actualAdditionalProperties, (Object)additionalProperties)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, additionalProperties, actualAdditionalProperties});
        }
        return (S)((Object)((AbstractOAuthClientAssert)this.myself));
    }

    public S hasApiVersion(OAuthClient.ApiVersion apiVersion) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting apiVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        OAuthClient.ApiVersion actualApiVersion = ((OAuthClient)this.actual).getApiVersion();
        if (!Objects.areEqual((Object)((Object)actualApiVersion), (Object)((Object)apiVersion))) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, apiVersion, actualApiVersion});
        }
        return (S)((Object)((AbstractOAuthClientAssert)this.myself));
    }

    public S hasKind(String kind) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting kind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualKind = ((OAuthClient)this.actual).getKind();
        if (!Objects.areEqual((Object)actualKind, (Object)kind)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, kind, actualKind});
        }
        return (S)((Object)((AbstractOAuthClientAssert)this.myself));
    }

    public S hasMetadata(ObjectMeta metadata) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting metadata of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        ObjectMeta actualMetadata = ((OAuthClient)this.actual).getMetadata();
        if (!Objects.areEqual((Object)actualMetadata, (Object)metadata)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, metadata, actualMetadata});
        }
        return (S)((Object)((AbstractOAuthClientAssert)this.myself));
    }

    public S hasRedirectURIs(String ... redirectURIs) {
        this.isNotNull();
        if (redirectURIs == null) {
            this.failWithMessage("Expecting redirectURIs parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, ((OAuthClient)this.actual).getRedirectURIs(), (Object[])redirectURIs);
        return (S)((Object)((AbstractOAuthClientAssert)this.myself));
    }

    public S hasOnlyRedirectURIs(String ... redirectURIs) {
        this.isNotNull();
        if (redirectURIs == null) {
            this.failWithMessage("Expecting redirectURIs parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, ((OAuthClient)this.actual).getRedirectURIs(), (Object[])redirectURIs);
        return (S)((Object)((AbstractOAuthClientAssert)this.myself));
    }

    public S doesNotHaveRedirectURIs(String ... redirectURIs) {
        this.isNotNull();
        if (redirectURIs == null) {
            this.failWithMessage("Expecting redirectURIs parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, ((OAuthClient)this.actual).getRedirectURIs(), (Object[])redirectURIs);
        return (S)((Object)((AbstractOAuthClientAssert)this.myself));
    }

    public S hasNoRedirectURIs() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have redirectURIs but had :\n  <%s>";
        if (((OAuthClient)this.actual).getRedirectURIs().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((OAuthClient)this.actual).getRedirectURIs()});
        }
        return (S)((Object)((AbstractOAuthClientAssert)this.myself));
    }

    public S hasRespondWithChallenges(Boolean respondWithChallenges) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting respondWithChallenges of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Boolean actualRespondWithChallenges = ((OAuthClient)this.actual).getRespondWithChallenges();
        if (!Objects.areEqual((Object)actualRespondWithChallenges, (Object)respondWithChallenges)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, respondWithChallenges, actualRespondWithChallenges});
        }
        return (S)((Object)((AbstractOAuthClientAssert)this.myself));
    }

    public S hasSecret(String secret) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting secret of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualSecret = ((OAuthClient)this.actual).getSecret();
        if (!Objects.areEqual((Object)actualSecret, (Object)secret)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, secret, actualSecret});
        }
        return (S)((Object)((AbstractOAuthClientAssert)this.myself));
    }
}

