/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.model.EndpointSubset;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.util.Map;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.internal.Iterables;
import org.assertj.core.util.Objects;

public abstract class AbstractEndpointsAssert<S extends AbstractEndpointsAssert<S, A>, A extends Endpoints>
extends AbstractAssert<S, A> {
    protected AbstractEndpointsAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public S hasAdditionalProperties(Map additionalProperties) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting additionalProperties of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Map<String, Object> actualAdditionalProperties = ((Endpoints)this.actual).getAdditionalProperties();
        if (!Objects.areEqual(actualAdditionalProperties, (Object)additionalProperties)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, additionalProperties, actualAdditionalProperties});
        }
        return (S)((Object)((AbstractEndpointsAssert)this.myself));
    }

    public S hasApiVersion(Endpoints.ApiVersion apiVersion) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting apiVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Endpoints.ApiVersion actualApiVersion = ((Endpoints)this.actual).getApiVersion();
        if (!Objects.areEqual((Object)((Object)actualApiVersion), (Object)((Object)apiVersion))) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, apiVersion, actualApiVersion});
        }
        return (S)((Object)((AbstractEndpointsAssert)this.myself));
    }

    public S hasKind(String kind) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting kind of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualKind = ((Endpoints)this.actual).getKind();
        if (!Objects.areEqual((Object)actualKind, (Object)kind)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, kind, actualKind});
        }
        return (S)((Object)((AbstractEndpointsAssert)this.myself));
    }

    public S hasMetadata(ObjectMeta metadata) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting metadata of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        ObjectMeta actualMetadata = ((Endpoints)this.actual).getMetadata();
        if (!Objects.areEqual((Object)actualMetadata, (Object)metadata)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, metadata, actualMetadata});
        }
        return (S)((Object)((AbstractEndpointsAssert)this.myself));
    }

    public S hasSubsets(EndpointSubset ... subsets) {
        this.isNotNull();
        if (subsets == null) {
            this.failWithMessage("Expecting subsets parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, ((Endpoints)this.actual).getSubsets(), (Object[])subsets);
        return (S)((Object)((AbstractEndpointsAssert)this.myself));
    }

    public S hasOnlySubsets(EndpointSubset ... subsets) {
        this.isNotNull();
        if (subsets == null) {
            this.failWithMessage("Expecting subsets parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, ((Endpoints)this.actual).getSubsets(), (Object[])subsets);
        return (S)((Object)((AbstractEndpointsAssert)this.myself));
    }

    public S doesNotHaveSubsets(EndpointSubset ... subsets) {
        this.isNotNull();
        if (subsets == null) {
            this.failWithMessage("Expecting subsets parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, ((Endpoints)this.actual).getSubsets(), (Object[])subsets);
        return (S)((Object)((AbstractEndpointsAssert)this.myself));
    }

    public S hasNoSubsets() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have subsets but had :\n  <%s>";
        if (((Endpoints)this.actual).getSubsets().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((Endpoints)this.actual).getSubsets()});
        }
        return (S)((Object)((AbstractEndpointsAssert)this.myself));
    }
}

