/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.EditableSecretSpec;
import io.fabric8.openshift.api.model.SecretSpec;
import io.fabric8.openshift.api.model.SecretSpecFluent;
import io.fabric8.openshift.api.model.SecretSpecFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class SecretSpecBuilder
extends SecretSpecFluentImpl<SecretSpecBuilder>
implements VisitableBuilder<SecretSpec, SecretSpecBuilder> {
    SecretSpecFluent<?> fluent;

    public SecretSpecBuilder() {
        this(new SecretSpec());
    }

    public SecretSpecBuilder(SecretSpecFluent<?> fluent) {
        this(fluent, new SecretSpec());
    }

    public SecretSpecBuilder(SecretSpecFluent<?> fluent, SecretSpec instance) {
        this.fluent = fluent;
        fluent.withMountPath(instance.getMountPath());
        fluent.withSecretSource(instance.getSecretSource());
    }

    public SecretSpecBuilder(SecretSpec instance) {
        this.fluent = this;
        this.withMountPath(instance.getMountPath());
        this.withSecretSource(instance.getSecretSource());
    }

    public EditableSecretSpec build() {
        EditableSecretSpec buildable = new EditableSecretSpec(this.fluent.getMountPath(), this.fluent.getSecretSource());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SecretSpecBuilder that = (SecretSpecBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

