/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.assertions;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.assertions.Conditions;
import io.fabric8.kubernetes.assertions.PodLogsAssert;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ClientPodResource;
import io.fabric8.utils.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.assertj.core.api.IntegerAssert;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.filter.Filters;
import org.assertj.core.util.Lists;

public class PodsAssert
extends ListAssert<Pod> {
    private final KubernetesClient client;

    public PodsAssert(List<Pod> actual, KubernetesClient client) {
        super(actual);
        this.client = client;
    }

    public PodsAssert filter(Condition<Pod> condition) {
        return PodsAssert.assertThat(Filters.filter((Iterable)((Iterable)this.actual)).having(condition).get(), this.client);
    }

    public IntegerAssert assertSize() {
        return (IntegerAssert)Assertions.assertThat((int)this.get().size()).as("size", new Object[0]);
    }

    public List<Pod> get() {
        return (List)this.actual;
    }

    public PodLogsAssert logs() {
        return this.logs(null);
    }

    public PodLogsAssert logs(String containerName) {
        HashMap<String, String> logs = new HashMap<String, String>();
        List<Pod> pods = this.get();
        for (Pod pod : pods) {
            String log;
            ObjectMeta metadata = pod.getMetadata();
            if (metadata == null) continue;
            String name = metadata.getName();
            String namespace = metadata.getNamespace();
            String key = name;
            if (Strings.isNotBlank((String)namespace)) {
                key = namespace + "/" + name;
            }
            if ((log = (String)((ClientPodResource)((ClientNonNamespaceOperation)this.client.pods().inNamespace(namespace)).withName(name)).getLog(containerName, Boolean.valueOf(true))) == null) continue;
            logs.put(key, log);
        }
        return new PodLogsAssert(logs, containerName);
    }

    public PodsAssert filterLabel(String key, String value) {
        return this.filter(Conditions.podLabel(key, value));
    }

    public PodsAssert filterNamespace(String namespace) {
        return this.filter(Conditions.podNamespace(namespace));
    }

    public PodsAssert runningStatus() {
        return this.filter(Conditions.runningStatus());
    }

    public PodsAssert waitingStatus() {
        return this.filter(Conditions.waitingStatus());
    }

    public PodsAssert errorStatus() {
        return this.filter(Conditions.errorStatus());
    }

    protected static PodsAssert assertThat(Iterable<Pod> result, KubernetesClient client) {
        ArrayList list = Lists.newArrayList(result);
        return new PodsAssert(list, client);
    }
}

