/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.PersistentVolume;
import io.fabric8.kubernetes.api.model.PersistentVolumeFluent;
import io.fabric8.kubernetes.api.model.PersistentVolumeSpec;
import io.fabric8.kubernetes.api.model.PersistentVolumeSpecBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeSpecFluentImpl;
import io.fabric8.kubernetes.api.model.PersistentVolumeStatus;
import io.fabric8.kubernetes.api.model.PersistentVolumeStatusBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeStatusFluentImpl;
import java.util.HashMap;
import java.util.Map;

public class PersistentVolumeFluentImpl<T extends PersistentVolumeFluent<T>>
extends BaseFluent<T>
implements PersistentVolumeFluent<T> {
    PersistentVolume.ApiVersion apiVersion;
    String kind;
    VisitableBuilder<ObjectMeta, ?> metadata;
    VisitableBuilder<PersistentVolumeSpec, ?> spec;
    VisitableBuilder<PersistentVolumeStatus, ?> status;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public PersistentVolumeFluentImpl() {
    }

    public PersistentVolumeFluentImpl(PersistentVolume instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
    }

    @Override
    public PersistentVolume.ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public T withApiVersion(PersistentVolume.ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
        return (T)this;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public T withKind(String kind) {
        this.kind = kind;
        return (T)this;
    }

    @Override
    public ObjectMeta getMetadata() {
        return this.metadata != null ? (ObjectMeta)this.metadata.build() : null;
    }

    @Override
    public T withMetadata(ObjectMeta metadata) {
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (T)this;
    }

    @Override
    public PersistentVolumeFluent.MetadataNested<T> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public PersistentVolumeFluent.MetadataNested<T> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public PersistentVolumeFluent.MetadataNested<T> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public PersistentVolumeSpec getSpec() {
        return this.spec != null ? (PersistentVolumeSpec)this.spec.build() : null;
    }

    @Override
    public T withSpec(PersistentVolumeSpec spec) {
        if (spec != null) {
            this.spec = new PersistentVolumeSpecBuilder(spec);
            this._visitables.add(this.spec);
        }
        return (T)this;
    }

    @Override
    public PersistentVolumeFluent.SpecNested<T> withNewSpec() {
        return new SpecNestedImpl();
    }

    @Override
    public PersistentVolumeFluent.SpecNested<T> withNewSpecLike(PersistentVolumeSpec item) {
        return new SpecNestedImpl(item);
    }

    @Override
    public PersistentVolumeFluent.SpecNested<T> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    @Override
    public PersistentVolumeStatus getStatus() {
        return this.status != null ? (PersistentVolumeStatus)this.status.build() : null;
    }

    @Override
    public T withStatus(PersistentVolumeStatus status) {
        if (status != null) {
            this.status = new PersistentVolumeStatusBuilder(status);
            this._visitables.add(this.status);
        }
        return (T)this;
    }

    @Override
    public PersistentVolumeFluent.StatusNested<T> withNewStatus() {
        return new StatusNestedImpl();
    }

    @Override
    public PersistentVolumeFluent.StatusNested<T> withNewStatusLike(PersistentVolumeStatus item) {
        return new StatusNestedImpl(item);
    }

    @Override
    public PersistentVolumeFluent.StatusNested<T> editStatus() {
        return this.withNewStatusLike(this.getStatus());
    }

    @Override
    public T withNewStatus(String message, String phase, String reason) {
        return this.withStatus(new PersistentVolumeStatus(message, phase, reason));
    }

    @Override
    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.additionalProperties.remove(key);
            }
        }
        return (T)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PersistentVolumeFluentImpl that = (PersistentVolumeFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals((Object)that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.spec != null ? !this.spec.equals(that.spec) : that.spec != null) {
            return false;
        }
        if (this.status != null ? !this.status.equals(that.status) : that.status != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class StatusNestedImpl<N>
    extends PersistentVolumeStatusFluentImpl<PersistentVolumeFluent.StatusNested<N>>
    implements PersistentVolumeFluent.StatusNested<N> {
        private final PersistentVolumeStatusBuilder builder;

        StatusNestedImpl(PersistentVolumeStatus item) {
            this.builder = new PersistentVolumeStatusBuilder(this, item);
        }

        StatusNestedImpl() {
            this.builder = new PersistentVolumeStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeFluentImpl.this.withStatus(this.builder.build());
        }

        @Override
        public N endStatus() {
            return this.and();
        }
    }

    public class SpecNestedImpl<N>
    extends PersistentVolumeSpecFluentImpl<PersistentVolumeFluent.SpecNested<N>>
    implements PersistentVolumeFluent.SpecNested<N> {
        private final PersistentVolumeSpecBuilder builder;

        SpecNestedImpl() {
            this.builder = new PersistentVolumeSpecBuilder(this);
        }

        SpecNestedImpl(PersistentVolumeSpec item) {
            this.builder = new PersistentVolumeSpecBuilder(this, item);
        }

        @Override
        public N endSpec() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)PersistentVolumeFluentImpl.this.withSpec(this.builder.build());
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<PersistentVolumeFluent.MetadataNested<N>>
    implements PersistentVolumeFluent.MetadataNested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)PersistentVolumeFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

