/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.EditableServiceSpec;
import io.fabric8.kubernetes.api.model.ServiceSpec;
import io.fabric8.kubernetes.api.model.ServiceSpecFluent;
import io.fabric8.kubernetes.api.model.ServiceSpecFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ServiceSpecBuilder
extends ServiceSpecFluentImpl<ServiceSpecBuilder>
implements VisitableBuilder<ServiceSpec, ServiceSpecBuilder> {
    ServiceSpecFluent<?> fluent;

    public ServiceSpecBuilder() {
        this(new ServiceSpec());
    }

    public ServiceSpecBuilder(ServiceSpecFluent<?> fluent) {
        this(fluent, new ServiceSpec());
    }

    public ServiceSpecBuilder(ServiceSpecFluent<?> fluent, ServiceSpec instance) {
        this.fluent = fluent;
        fluent.withClusterIP(instance.getClusterIP());
        fluent.withDeprecatedPublicIPs(instance.getDeprecatedPublicIPs());
        fluent.withPortalIP(instance.getPortalIP());
        fluent.withPorts(instance.getPorts());
        fluent.withSelector(instance.getSelector());
        fluent.withSessionAffinity(instance.getSessionAffinity());
        fluent.withType(instance.getType());
    }

    public ServiceSpecBuilder(ServiceSpec instance) {
        this.fluent = this;
        this.withClusterIP(instance.getClusterIP());
        this.withDeprecatedPublicIPs(instance.getDeprecatedPublicIPs());
        this.withPortalIP(instance.getPortalIP());
        this.withPorts(instance.getPorts());
        this.withSelector(instance.getSelector());
        this.withSessionAffinity(instance.getSessionAffinity());
        this.withType(instance.getType());
    }

    public EditableServiceSpec build() {
        EditableServiceSpec buildable = new EditableServiceSpec(this.fluent.getClusterIP(), this.fluent.getDeprecatedPublicIPs(), this.fluent.getPortalIP(), this.fluent.getPorts(), this.fluent.getSelector(), this.fluent.getSessionAffinity(), this.fluent.getType());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServiceSpecBuilder that = (ServiceSpecBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

