/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import io.fabric8.openshift.api.model.BuildSource;
import io.fabric8.openshift.api.model.BuildSourceFluent;
import io.fabric8.openshift.api.model.GitBuildSource;
import io.fabric8.openshift.api.model.GitBuildSourceBuilder;
import io.fabric8.openshift.api.model.GitBuildSourceFluentImpl;
import java.util.HashMap;
import java.util.Map;

public class BuildSourceFluentImpl<T extends BuildSourceFluent<T>>
extends BaseFluent<T>
implements BuildSourceFluent<T> {
    String contextDir;
    VisitableBuilder<GitBuildSource, ?> git;
    VisitableBuilder<LocalObjectReference, ?> sourceSecret;
    String type;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public BuildSourceFluentImpl() {
    }

    public BuildSourceFluentImpl(BuildSource instance) {
        this.withContextDir(instance.getContextDir());
        this.withGit(instance.getGit());
        this.withSourceSecret(instance.getSourceSecret());
        this.withType(instance.getType());
    }

    @Override
    public String getContextDir() {
        return this.contextDir;
    }

    @Override
    public T withContextDir(String contextDir) {
        this.contextDir = contextDir;
        return (T)this;
    }

    @Override
    public GitBuildSource getGit() {
        return this.git != null ? (GitBuildSource)this.git.build() : null;
    }

    @Override
    public T withGit(GitBuildSource git) {
        if (git != null) {
            this.git = new GitBuildSourceBuilder(git);
            this._visitables.add(this.git);
        }
        return (T)this;
    }

    @Override
    public BuildSourceFluent.GitNested<T> withNewGit() {
        return new GitNestedImpl();
    }

    @Override
    public BuildSourceFluent.GitNested<T> withNewGitLike(GitBuildSource item) {
        return new GitNestedImpl(item);
    }

    @Override
    public BuildSourceFluent.GitNested<T> editGit() {
        return this.withNewGitLike(this.getGit());
    }

    @Override
    public T withNewGit(String httpProxy, String httpsProxy, String ref, String uri) {
        return this.withGit(new GitBuildSource(httpProxy, httpsProxy, ref, uri));
    }

    @Override
    public LocalObjectReference getSourceSecret() {
        return this.sourceSecret != null ? (LocalObjectReference)this.sourceSecret.build() : null;
    }

    @Override
    public T withSourceSecret(LocalObjectReference sourceSecret) {
        if (sourceSecret != null) {
            this.sourceSecret = new LocalObjectReferenceBuilder(sourceSecret);
            this._visitables.add(this.sourceSecret);
        }
        return (T)this;
    }

    @Override
    public BuildSourceFluent.SourceSecretNested<T> withNewSourceSecret() {
        return new SourceSecretNestedImpl();
    }

    @Override
    public BuildSourceFluent.SourceSecretNested<T> withNewSourceSecretLike(LocalObjectReference item) {
        return new SourceSecretNestedImpl(item);
    }

    @Override
    public BuildSourceFluent.SourceSecretNested<T> editSourceSecret() {
        return this.withNewSourceSecretLike(this.getSourceSecret());
    }

    @Override
    public T withNewSourceSecret(String name) {
        return this.withSourceSecret(new LocalObjectReference(name));
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public T withType(String type) {
        this.type = type;
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.additionalProperties.remove(key);
            }
        }
        return (T)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuildSourceFluentImpl that = (BuildSourceFluentImpl)o;
        if (this.contextDir != null ? !this.contextDir.equals(that.contextDir) : that.contextDir != null) {
            return false;
        }
        if (this.git != null ? !this.git.equals(that.git) : that.git != null) {
            return false;
        }
        if (this.sourceSecret != null ? !this.sourceSecret.equals(that.sourceSecret) : that.sourceSecret != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class SourceSecretNestedImpl<N>
    extends LocalObjectReferenceFluentImpl<BuildSourceFluent.SourceSecretNested<N>>
    implements BuildSourceFluent.SourceSecretNested<N> {
        private final LocalObjectReferenceBuilder builder;

        SourceSecretNestedImpl(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        SourceSecretNestedImpl() {
            this.builder = new LocalObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildSourceFluentImpl.this.withSourceSecret(this.builder.build());
        }

        @Override
        public N endSourceSecret() {
            return this.and();
        }
    }

    public class GitNestedImpl<N>
    extends GitBuildSourceFluentImpl<BuildSourceFluent.GitNested<N>>
    implements BuildSourceFluent.GitNested<N> {
        private final GitBuildSourceBuilder builder;

        GitNestedImpl() {
            this.builder = new GitBuildSourceBuilder(this);
        }

        GitNestedImpl(GitBuildSource item) {
            this.builder = new GitBuildSourceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)BuildSourceFluentImpl.this.withGit(this.builder.build());
        }

        @Override
        public N endGit() {
            return this.and();
        }
    }
}

