/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ListMeta;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;
import io.fabric8.kubernetes.api.model.ListMetaFluentImpl;
import io.fabric8.kubernetes.api.model.Status;
import io.fabric8.kubernetes.api.model.StatusDetails;
import io.fabric8.kubernetes.api.model.StatusDetailsBuilder;
import io.fabric8.kubernetes.api.model.StatusDetailsFluentImpl;
import io.fabric8.kubernetes.api.model.StatusFluent;
import java.util.HashMap;
import java.util.Map;

public class StatusFluentImpl<T extends StatusFluent<T>>
extends BaseFluent<T>
implements StatusFluent<T> {
    Status.ApiVersion apiVersion;
    Integer code;
    VisitableBuilder<StatusDetails, ?> details;
    String kind;
    String message;
    VisitableBuilder<ListMeta, ?> metadata;
    String reason;
    String status;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    @Override
    public Status.ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public T withApiVersion(Status.ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
        return (T)this;
    }

    @Override
    public Integer getCode() {
        return this.code;
    }

    @Override
    public T withCode(Integer code) {
        this.code = code;
        return (T)this;
    }

    @Override
    public StatusDetails getDetails() {
        return this.details != null ? (StatusDetails)this.details.build() : null;
    }

    @Override
    public T withDetails(StatusDetails details) {
        if (details != null) {
            this.details = new StatusDetailsBuilder(details);
            this._visitables.add(this.details);
        }
        return (T)this;
    }

    @Override
    public StatusFluent.DetailsNested<T> withNewDetails() {
        return new DetailsNestedImpl();
    }

    @Override
    public StatusFluent.DetailsNested<T> withNewDetailsLike(StatusDetails item) {
        return new DetailsNestedImpl(item);
    }

    @Override
    public StatusFluent.DetailsNested<T> editDetails() {
        return this.withNewDetailsLike(this.getDetails());
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public T withKind(String kind) {
        this.kind = kind;
        return (T)this;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public T withMessage(String message) {
        this.message = message;
        return (T)this;
    }

    @Override
    public ListMeta getMetadata() {
        return this.metadata != null ? (ListMeta)this.metadata.build() : null;
    }

    @Override
    public T withMetadata(ListMeta metadata) {
        if (metadata != null) {
            this.metadata = new ListMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (T)this;
    }

    @Override
    public StatusFluent.MetadataNested<T> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public StatusFluent.MetadataNested<T> withNewMetadataLike(ListMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public StatusFluent.MetadataNested<T> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public T withNewMetadata(String resourceVersion, String selfLink) {
        return this.withMetadata(new ListMeta(resourceVersion, selfLink));
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    @Override
    public T withReason(String reason) {
        this.reason = reason;
        return (T)this;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public T withStatus(String status) {
        this.status = status;
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatusFluentImpl that = (StatusFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals((Object)that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.code != null ? !this.code.equals(that.code) : that.code != null) {
            return false;
        }
        if (this.details != null ? !this.details.equals(that.details) : that.details != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.message != null ? !this.message.equals(that.message) : that.message != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.reason != null ? !this.reason.equals(that.reason) : that.reason != null) {
            return false;
        }
        if (this.status != null ? !this.status.equals(that.status) : that.status != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class MetadataNestedImpl<N>
    extends ListMetaFluentImpl<StatusFluent.MetadataNested<N>>
    implements StatusFluent.MetadataNested<N> {
        private final ListMetaBuilder builder;

        MetadataNestedImpl() {
            this.builder = new ListMetaBuilder(this);
        }

        MetadataNestedImpl(ListMeta item) {
            this.builder = new ListMetaBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)StatusFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }

    public class DetailsNestedImpl<N>
    extends StatusDetailsFluentImpl<StatusFluent.DetailsNested<N>>
    implements StatusFluent.DetailsNested<N> {
        private final StatusDetailsBuilder builder;

        DetailsNestedImpl(StatusDetails item) {
            this.builder = new StatusDetailsBuilder(this, item);
        }

        DetailsNestedImpl() {
            this.builder = new StatusDetailsBuilder(this);
        }

        @Override
        public N and() {
            return (N)StatusFluentImpl.this.withDetails(this.builder.build());
        }

        @Override
        public N endDetails() {
            return this.and();
        }
    }
}

