/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.Capabilities;
import io.fabric8.kubernetes.api.model.CapabilitiesBuilder;
import io.fabric8.kubernetes.api.model.CapabilitiesFluentImpl;
import io.fabric8.kubernetes.api.model.SELinuxOptions;
import io.fabric8.kubernetes.api.model.SELinuxOptionsBuilder;
import io.fabric8.kubernetes.api.model.SELinuxOptionsFluentImpl;
import io.fabric8.kubernetes.api.model.SecurityContextFluent;
import java.util.HashMap;
import java.util.Map;

public class SecurityContextFluentImpl<T extends SecurityContextFluent<T>>
extends BaseFluent<T>
implements SecurityContextFluent<T> {
    VisitableBuilder<Capabilities, ?> capabilities;
    Boolean privileged;
    Boolean runAsNonRoot;
    Long runAsUser;
    VisitableBuilder<SELinuxOptions, ?> seLinuxOptions;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    @Override
    public Capabilities getCapabilities() {
        return this.capabilities != null ? (Capabilities)this.capabilities.build() : null;
    }

    @Override
    public T withCapabilities(Capabilities capabilities) {
        if (capabilities != null) {
            this.capabilities = new CapabilitiesBuilder(capabilities);
            this._visitables.add(this.capabilities);
        }
        return (T)this;
    }

    @Override
    public SecurityContextFluent.CapabilitiesNested<T> withNewCapabilities() {
        return new CapabilitiesNestedImpl();
    }

    @Override
    public SecurityContextFluent.CapabilitiesNested<T> withNewCapabilitiesLike(Capabilities item) {
        return new CapabilitiesNestedImpl(item);
    }

    @Override
    public SecurityContextFluent.CapabilitiesNested<T> editCapabilities() {
        return this.withNewCapabilitiesLike(this.getCapabilities());
    }

    @Override
    public Boolean isPrivileged() {
        return this.privileged;
    }

    @Override
    public T withPrivileged(Boolean privileged) {
        this.privileged = privileged;
        return (T)this;
    }

    @Override
    public Boolean isRunAsNonRoot() {
        return this.runAsNonRoot;
    }

    @Override
    public T withRunAsNonRoot(Boolean runAsNonRoot) {
        this.runAsNonRoot = runAsNonRoot;
        return (T)this;
    }

    @Override
    public Long getRunAsUser() {
        return this.runAsUser;
    }

    @Override
    public T withRunAsUser(Long runAsUser) {
        this.runAsUser = runAsUser;
        return (T)this;
    }

    @Override
    public SELinuxOptions getSeLinuxOptions() {
        return this.seLinuxOptions != null ? (SELinuxOptions)this.seLinuxOptions.build() : null;
    }

    @Override
    public T withSeLinuxOptions(SELinuxOptions seLinuxOptions) {
        if (seLinuxOptions != null) {
            this.seLinuxOptions = new SELinuxOptionsBuilder(seLinuxOptions);
            this._visitables.add(this.seLinuxOptions);
        }
        return (T)this;
    }

    @Override
    public SecurityContextFluent.SeLinuxOptionsNested<T> withNewSeLinuxOptions() {
        return new SeLinuxOptionsNestedImpl();
    }

    @Override
    public SecurityContextFluent.SeLinuxOptionsNested<T> withNewSeLinuxOptionsLike(SELinuxOptions item) {
        return new SeLinuxOptionsNestedImpl(item);
    }

    @Override
    public SecurityContextFluent.SeLinuxOptionsNested<T> editSeLinuxOptions() {
        return this.withNewSeLinuxOptionsLike(this.getSeLinuxOptions());
    }

    @Override
    public T withNewSeLinuxOptions(String level, String role, String type, String user) {
        return this.withSeLinuxOptions(new SELinuxOptions(level, role, type, user));
    }

    @Override
    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecurityContextFluentImpl that = (SecurityContextFluentImpl)o;
        if (this.capabilities != null ? !this.capabilities.equals(that.capabilities) : that.capabilities != null) {
            return false;
        }
        if (this.privileged != null ? !this.privileged.equals(that.privileged) : that.privileged != null) {
            return false;
        }
        if (this.runAsNonRoot != null ? !this.runAsNonRoot.equals(that.runAsNonRoot) : that.runAsNonRoot != null) {
            return false;
        }
        if (this.runAsUser != null ? !this.runAsUser.equals(that.runAsUser) : that.runAsUser != null) {
            return false;
        }
        if (this.seLinuxOptions != null ? !this.seLinuxOptions.equals(that.seLinuxOptions) : that.seLinuxOptions != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class SeLinuxOptionsNestedImpl<N>
    extends SELinuxOptionsFluentImpl<SecurityContextFluent.SeLinuxOptionsNested<N>>
    implements SecurityContextFluent.SeLinuxOptionsNested<N> {
        private final SELinuxOptionsBuilder builder;

        SeLinuxOptionsNestedImpl() {
            this.builder = new SELinuxOptionsBuilder(this);
        }

        SeLinuxOptionsNestedImpl(SELinuxOptions item) {
            this.builder = new SELinuxOptionsBuilder(this, item);
        }

        @Override
        public N endSeLinuxOptions() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)SecurityContextFluentImpl.this.withSeLinuxOptions(this.builder.build());
        }
    }

    public class CapabilitiesNestedImpl<N>
    extends CapabilitiesFluentImpl<SecurityContextFluent.CapabilitiesNested<N>>
    implements SecurityContextFluent.CapabilitiesNested<N> {
        private final CapabilitiesBuilder builder;

        CapabilitiesNestedImpl() {
            this.builder = new CapabilitiesBuilder(this);
        }

        CapabilitiesNestedImpl(Capabilities item) {
            this.builder = new CapabilitiesBuilder(this, item);
        }

        @Override
        public N endCapabilities() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)SecurityContextFluentImpl.this.withCapabilities(this.builder.build());
        }
    }
}

