/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.EditableExecAction;
import io.fabric8.kubernetes.api.model.ExecAction;
import io.fabric8.kubernetes.api.model.ExecActionFluent;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ExecActionBuilder
extends ExecActionFluent<ExecActionBuilder>
implements VisitableBuilder<ExecAction, ExecActionBuilder> {
    ExecActionFluent<?> fluent;

    public ExecActionBuilder() {
        this(new ExecAction());
    }

    public ExecActionBuilder(ExecActionFluent<?> fluent) {
        this(fluent, new ExecAction());
    }

    public ExecActionBuilder(ExecActionFluent<?> fluent, ExecAction instance) {
        this.fluent = fluent;
        fluent.withCommand(instance.getCommand());
    }

    public ExecActionBuilder(ExecAction instance) {
        this.fluent = this;
        this.withCommand(instance.getCommand());
    }

    public EditableExecAction build() {
        EditableExecAction buildable = new EditableExecAction(this.fluent.getCommand());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ExecActionBuilder that = (ExecActionBuilder)((Object)o);
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

