/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.openshift.api.model.DeploymentStrategy;
import io.fabric8.openshift.api.model.DeploymentTriggerPolicy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"replicas", "selector", "strategy", "template", "triggers"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class DeploymentConfigSpec {
    @JsonProperty(value="replicas")
    private Integer replicas;
    @JsonProperty(value="selector")
    @Valid
    private Map<String, String> selector;
    @JsonProperty(value="strategy")
    @Valid
    private DeploymentStrategy strategy;
    @JsonProperty(value="template")
    @Valid
    private PodTemplateSpec template;
    @JsonProperty(value="triggers")
    @Valid
    private List<DeploymentTriggerPolicy> triggers = new ArrayList<DeploymentTriggerPolicy>();
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public DeploymentConfigSpec() {
    }

    public DeploymentConfigSpec(Integer replicas, Map<String, String> selector, DeploymentStrategy strategy, PodTemplateSpec template, List<DeploymentTriggerPolicy> triggers) {
        this.replicas = replicas;
        this.selector = selector;
        this.strategy = strategy;
        this.template = template;
        this.triggers = triggers;
    }

    @JsonProperty(value="replicas")
    public Integer getReplicas() {
        return this.replicas;
    }

    @JsonProperty(value="replicas")
    public void setReplicas(Integer replicas) {
        this.replicas = replicas;
    }

    @JsonProperty(value="selector")
    public Map<String, String> getSelector() {
        return this.selector;
    }

    @JsonProperty(value="selector")
    public void setSelector(Map<String, String> selector) {
        this.selector = selector;
    }

    @JsonProperty(value="strategy")
    public DeploymentStrategy getStrategy() {
        return this.strategy;
    }

    @JsonProperty(value="strategy")
    public void setStrategy(DeploymentStrategy strategy) {
        this.strategy = strategy;
    }

    @JsonProperty(value="template")
    public PodTemplateSpec getTemplate() {
        return this.template;
    }

    @JsonProperty(value="template")
    public void setTemplate(PodTemplateSpec template) {
        this.template = template;
    }

    @JsonProperty(value="triggers")
    public List<DeploymentTriggerPolicy> getTriggers() {
        return this.triggers;
    }

    @JsonProperty(value="triggers")
    public void setTriggers(List<DeploymentTriggerPolicy> triggers) {
        this.triggers = triggers;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public String toString() {
        return "DeploymentConfigSpec(replicas=" + this.getReplicas() + ", selector=" + this.getSelector() + ", strategy=" + this.getStrategy() + ", template=" + this.getTemplate() + ", triggers=" + this.getTriggers() + ", additionalProperties=" + this.getAdditionalProperties() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeploymentConfigSpec)) {
            return false;
        }
        DeploymentConfigSpec other = (DeploymentConfigSpec)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$replicas = this.getReplicas();
        Integer other$replicas = other.getReplicas();
        if (this$replicas == null ? other$replicas != null : !((Object)this$replicas).equals(other$replicas)) {
            return false;
        }
        Map<String, String> this$selector = this.getSelector();
        Map<String, String> other$selector = other.getSelector();
        if (this$selector == null ? other$selector != null : !((Object)this$selector).equals(other$selector)) {
            return false;
        }
        DeploymentStrategy this$strategy = this.getStrategy();
        DeploymentStrategy other$strategy = other.getStrategy();
        if (this$strategy == null ? other$strategy != null : !((Object)this$strategy).equals(other$strategy)) {
            return false;
        }
        PodTemplateSpec this$template = this.getTemplate();
        PodTemplateSpec other$template = other.getTemplate();
        if (this$template == null ? other$template != null : !((Object)this$template).equals(other$template)) {
            return false;
        }
        List<DeploymentTriggerPolicy> this$triggers = this.getTriggers();
        List<DeploymentTriggerPolicy> other$triggers = other.getTriggers();
        if (this$triggers == null ? other$triggers != null : !((Object)this$triggers).equals(other$triggers)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeploymentConfigSpec;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $replicas = this.getReplicas();
        result = result * 59 + ($replicas == null ? 0 : ((Object)$replicas).hashCode());
        Map<String, String> $selector = this.getSelector();
        result = result * 59 + ($selector == null ? 0 : ((Object)$selector).hashCode());
        DeploymentStrategy $strategy = this.getStrategy();
        result = result * 59 + ($strategy == null ? 0 : ((Object)$strategy).hashCode());
        PodTemplateSpec $template = this.getTemplate();
        result = result * 59 + ($template == null ? 0 : ((Object)$template).hashCode());
        List<DeploymentTriggerPolicy> $triggers = this.getTriggers();
        result = result * 59 + ($triggers == null ? 0 : ((Object)$triggers).hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 0 : ((Object)$additionalProperties).hashCode());
        return result;
    }
}

