/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.ValidationUtils;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.DeploymentConfigStatus;
import io.fabric8.openshift.api.model.DeploymentConfigStatusFluent;
import io.fabric8.openshift.api.model.DeploymentConfigStatusFluentImpl;

public class DeploymentConfigStatusBuilder
extends DeploymentConfigStatusFluentImpl<DeploymentConfigStatusBuilder>
implements VisitableBuilder<DeploymentConfigStatus, DeploymentConfigStatusBuilder> {
    DeploymentConfigStatusFluent<?> fluent;
    Boolean validationEnabled;

    public DeploymentConfigStatusBuilder() {
        this(true);
    }

    public DeploymentConfigStatusBuilder(Boolean validationEnabled) {
        this(new DeploymentConfigStatus(), validationEnabled);
    }

    public DeploymentConfigStatusBuilder(DeploymentConfigStatusFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public DeploymentConfigStatusBuilder(DeploymentConfigStatusFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new DeploymentConfigStatus(), validationEnabled);
    }

    public DeploymentConfigStatusBuilder(DeploymentConfigStatusFluent<?> fluent, DeploymentConfigStatus instance) {
        this(fluent, instance, true);
    }

    public DeploymentConfigStatusBuilder(DeploymentConfigStatusFluent<?> fluent, DeploymentConfigStatus instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAvailableReplicas(instance.getAvailableReplicas());
        fluent.withConditions(instance.getConditions());
        fluent.withDetails(instance.getDetails());
        fluent.withLatestVersion(instance.getLatestVersion());
        fluent.withObservedGeneration(instance.getObservedGeneration());
        fluent.withReadyReplicas(instance.getReadyReplicas());
        fluent.withReplicas(instance.getReplicas());
        fluent.withUnavailableReplicas(instance.getUnavailableReplicas());
        fluent.withUpdatedReplicas(instance.getUpdatedReplicas());
        this.validationEnabled = validationEnabled;
    }

    public DeploymentConfigStatusBuilder(DeploymentConfigStatus instance) {
        this(instance, (Boolean)true);
    }

    public DeploymentConfigStatusBuilder(DeploymentConfigStatus instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAvailableReplicas(instance.getAvailableReplicas());
        this.withConditions(instance.getConditions());
        this.withDetails(instance.getDetails());
        this.withLatestVersion(instance.getLatestVersion());
        this.withObservedGeneration(instance.getObservedGeneration());
        this.withReadyReplicas(instance.getReadyReplicas());
        this.withReplicas(instance.getReplicas());
        this.withUnavailableReplicas(instance.getUnavailableReplicas());
        this.withUpdatedReplicas(instance.getUpdatedReplicas());
        this.validationEnabled = validationEnabled;
    }

    public DeploymentConfigStatus build() {
        DeploymentConfigStatus buildable = new DeploymentConfigStatus(this.fluent.getAvailableReplicas(), this.fluent.getConditions(), this.fluent.getDetails(), this.fluent.getLatestVersion(), this.fluent.getObservedGeneration(), this.fluent.getReadyReplicas(), this.fluent.getReplicas(), this.fluent.getUnavailableReplicas(), this.fluent.getUpdatedReplicas());
        ValidationUtils.validate((Object)buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeploymentConfigStatusBuilder that = (DeploymentConfigStatusBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

