/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.ObjectMetaAssert;
import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;
import io.fabric8.openshift.api.model.ImageAssert;
import io.fabric8.openshift.api.model.ImageStreamTag;
import io.fabric8.openshift.api.model.TagEventCondition;
import io.fabric8.openshift.api.model.TagEventConditionAssert;
import io.fabric8.openshift.api.model.TagReferenceAssert;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.StringAssert;
import org.assertj.core.util.Objects;

public abstract class AbstractImageStreamTagAssert<S extends AbstractImageStreamTagAssert<S, A>, A extends ImageStreamTag>
extends AbstractAssert<S, A> {
    protected AbstractImageStreamTagAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public MapAssert additionalProperties() {
        this.isNotNull();
        return (MapAssert)Assertions.assertThat(((ImageStreamTag)this.actual).getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"), new Object[0]);
    }

    public StringAssert apiVersion() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((ImageStreamTag)this.actual).getApiVersion()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "apiVersion"), new Object[0]);
    }

    public NavigationListAssert<TagEventCondition, TagEventConditionAssert> conditions() {
        this.isNotNull();
        AssertFactory<TagEventCondition, TagEventConditionAssert> assertFactory = new AssertFactory<TagEventCondition, TagEventConditionAssert>(){

            @Override
            public TagEventConditionAssert createAssert(TagEventCondition t) {
                return io.fabric8.openshift.assertions.Assertions.assertThat(t);
            }
        };
        NavigationListAssert<TagEventCondition, TagEventConditionAssert> answer = new NavigationListAssert<TagEventCondition, TagEventConditionAssert>(((ImageStreamTag)this.actual).getConditions(), assertFactory);
        answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "conditions"), new Object[0]);
        return answer;
    }

    public S hasGeneration(Long generation) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting generation of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Long actualGeneration = ((ImageStreamTag)this.actual).getGeneration();
        if (!Objects.areEqual((Object)actualGeneration, (Object)generation)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, generation, actualGeneration});
        }
        return (S)((Object)((AbstractImageStreamTagAssert)this.myself));
    }

    public ImageAssert image() {
        this.isNotNull();
        return (ImageAssert)io.fabric8.openshift.assertions.Assertions.assertThat(((ImageStreamTag)this.actual).getImage()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "image"), new Object[0]);
    }

    public StringAssert kind() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((ImageStreamTag)this.actual).getKind()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "kind"), new Object[0]);
    }

    public ObjectMetaAssert metadata() {
        this.isNotNull();
        return (ObjectMetaAssert)io.fabric8.openshift.assertions.Assertions.assertThat(((ImageStreamTag)this.actual).getMetadata()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "metadata"), new Object[0]);
    }

    public TagReferenceAssert tag() {
        this.isNotNull();
        return (TagReferenceAssert)io.fabric8.openshift.assertions.Assertions.assertThat(((ImageStreamTag)this.actual).getTag()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "tag"), new Object[0]);
    }
}

