/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.EditableQuantity;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.QuantityFluent;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class QuantityBuilder
extends QuantityFluent<QuantityBuilder>
implements VisitableBuilder<Quantity, QuantityBuilder> {
    QuantityFluent<?> fluent;

    public QuantityBuilder() {
        this(new Quantity());
    }

    public QuantityBuilder(QuantityFluent<?> fluent) {
        this(fluent, new Quantity());
    }

    public QuantityBuilder(QuantityFluent<?> fluent, Quantity instance) {
        this.fluent = fluent;
        fluent.withAmount(instance.getAmount());
    }

    public QuantityBuilder(Quantity instance) {
        this.fluent = this;
        this.withAmount(instance.getAmount());
    }

    public EditableQuantity build() {
        EditableQuantity buildable = new EditableQuantity(this.fluent.getAmount());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

