/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.openshift.api.model.Image;
import io.fabric8.openshift.api.model.ImageBuilder;
import io.fabric8.openshift.api.model.ImageFluentImpl;
import io.fabric8.openshift.api.model.ImageStreamTag;
import io.fabric8.openshift.api.model.ImageStreamTagFluent;
import io.fabric8.openshift.api.model.TagEventCondition;
import io.fabric8.openshift.api.model.TagEventConditionBuilder;
import io.fabric8.openshift.api.model.TagEventConditionFluentImpl;
import io.fabric8.openshift.api.model.TagReference;
import io.fabric8.openshift.api.model.TagReferenceBuilder;
import io.fabric8.openshift.api.model.TagReferenceFluentImpl;
import java.util.ArrayList;
import java.util.List;

public class ImageStreamTagFluentImpl<A extends ImageStreamTagFluent<A>>
extends BaseFluent<A>
implements ImageStreamTagFluent<A> {
    private String apiVersion;
    private List<VisitableBuilder<? extends TagEventCondition, ?>> conditions = new ArrayList();
    private Long generation;
    private VisitableBuilder<? extends Image, ?> image;
    private String kind;
    private VisitableBuilder<? extends ObjectMeta, ?> metadata;
    private VisitableBuilder<? extends TagReference, ?> tag;

    public ImageStreamTagFluentImpl() {
    }

    public ImageStreamTagFluentImpl(ImageStreamTag instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withConditions(instance.getConditions());
        this.withGeneration(instance.getGeneration());
        this.withImage(instance.getImage());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withTag(instance.getTag());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public A addToConditions(TagEventCondition ... items) {
        for (TagEventCondition item : items) {
            TagEventConditionBuilder builder = new TagEventConditionBuilder(item);
            this._visitables.add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(TagEventCondition ... items) {
        for (TagEventCondition item : items) {
            TagEventConditionBuilder builder = new TagEventConditionBuilder(item);
            this._visitables.remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public List<TagEventCondition> getConditions() {
        return ImageStreamTagFluentImpl.build(this.conditions);
    }

    @Override
    public A withConditions(List<TagEventCondition> conditions) {
        this.conditions.clear();
        if (conditions != null) {
            for (TagEventCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withConditions(TagEventCondition ... conditions) {
        this.conditions.clear();
        if (conditions != null) {
            for (TagEventCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public ImageStreamTagFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    @Override
    public ImageStreamTagFluent.ConditionsNested<A> addNewConditionLike(TagEventCondition item) {
        return new ConditionsNestedImpl(item);
    }

    @Override
    public Long getGeneration() {
        return this.generation;
    }

    @Override
    public A withGeneration(Long generation) {
        this.generation = generation;
        return (A)this;
    }

    @Override
    public Image getImage() {
        return this.image != null ? (Image)this.image.build() : null;
    }

    @Override
    public A withImage(Image image) {
        if (image != null) {
            this.image = new ImageBuilder(image);
            this._visitables.add(this.image);
        }
        return (A)this;
    }

    @Override
    public ImageStreamTagFluent.ImageNested<A> withNewImage() {
        return new ImageNestedImpl();
    }

    @Override
    public ImageStreamTagFluent.ImageNested<A> withNewImageLike(Image item) {
        return new ImageNestedImpl(item);
    }

    @Override
    public ImageStreamTagFluent.ImageNested<A> editImage() {
        return this.withNewImageLike(this.getImage());
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public ObjectMeta getMetadata() {
        return this.metadata != null ? (ObjectMeta)this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public ImageStreamTagFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public ImageStreamTagFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public ImageStreamTagFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public TagReference getTag() {
        return this.tag != null ? (TagReference)this.tag.build() : null;
    }

    @Override
    public A withTag(TagReference tag) {
        if (tag != null) {
            this.tag = new TagReferenceBuilder(tag);
            this._visitables.add(this.tag);
        }
        return (A)this;
    }

    @Override
    public ImageStreamTagFluent.TagNested<A> withNewTag() {
        return new TagNestedImpl();
    }

    @Override
    public ImageStreamTagFluent.TagNested<A> withNewTagLike(TagReference item) {
        return new TagNestedImpl(item);
    }

    @Override
    public ImageStreamTagFluent.TagNested<A> editTag() {
        return this.withNewTagLike(this.getTag());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImageStreamTagFluentImpl that = (ImageStreamTagFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) {
            return false;
        }
        if (this.generation != null ? !this.generation.equals(that.generation) : that.generation != null) {
            return false;
        }
        if (this.image != null ? !this.image.equals(that.image) : that.image != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        return !(this.tag != null ? !this.tag.equals(that.tag) : that.tag != null);
    }

    public class TagNestedImpl<N>
    extends TagReferenceFluentImpl<ImageStreamTagFluent.TagNested<N>>
    implements ImageStreamTagFluent.TagNested<N>,
    Nested<N> {
        private final TagReferenceBuilder builder;

        TagNestedImpl() {
            this.builder = new TagReferenceBuilder(this);
        }

        TagNestedImpl(TagReference item) {
            this.builder = new TagReferenceBuilder(this, item);
        }

        @Override
        public N endTag() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)ImageStreamTagFluentImpl.this.withTag(this.builder.build());
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<ImageStreamTagFluent.MetadataNested<N>>
    implements ImageStreamTagFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)ImageStreamTagFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }

    public class ImageNestedImpl<N>
    extends ImageFluentImpl<ImageStreamTagFluent.ImageNested<N>>
    implements ImageStreamTagFluent.ImageNested<N>,
    Nested<N> {
        private final ImageBuilder builder;

        ImageNestedImpl() {
            this.builder = new ImageBuilder(this);
        }

        ImageNestedImpl(Image item) {
            this.builder = new ImageBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ImageStreamTagFluentImpl.this.withImage(this.builder.build());
        }

        @Override
        public N endImage() {
            return this.and();
        }
    }

    public class ConditionsNestedImpl<N>
    extends TagEventConditionFluentImpl<ImageStreamTagFluent.ConditionsNested<N>>
    implements ImageStreamTagFluent.ConditionsNested<N>,
    Nested<N> {
        private final TagEventConditionBuilder builder;

        ConditionsNestedImpl() {
            this.builder = new TagEventConditionBuilder(this);
        }

        ConditionsNestedImpl(TagEventCondition item) {
            this.builder = new TagEventConditionBuilder(this, item);
        }

        @Override
        public N endCondition() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)ImageStreamTagFluentImpl.this.addToConditions(this.builder.build());
        }
    }
}

