/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.openshift.api.model.ClusterPolicyBinding;
import io.fabric8.openshift.api.model.ClusterPolicyBindingFluent;
import io.fabric8.openshift.api.model.NamedClusterRoleBinding;
import io.fabric8.openshift.api.model.NamedClusterRoleBindingBuilder;
import io.fabric8.openshift.api.model.NamedClusterRoleBindingFluentImpl;
import java.util.ArrayList;
import java.util.List;

public class ClusterPolicyBindingFluentImpl<A extends ClusterPolicyBindingFluent<A>>
extends BaseFluent<A>
implements ClusterPolicyBindingFluent<A> {
    private String apiVersion;
    private String kind;
    private String lastModified;
    private VisitableBuilder<? extends ObjectMeta, ?> metadata;
    private VisitableBuilder<? extends ObjectReference, ?> policyRef;
    private List<VisitableBuilder<? extends NamedClusterRoleBinding, ?>> roleBindings = new ArrayList();

    public ClusterPolicyBindingFluentImpl() {
    }

    public ClusterPolicyBindingFluentImpl(ClusterPolicyBinding instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withLastModified(instance.getLastModified());
        this.withMetadata(instance.getMetadata());
        this.withPolicyRef(instance.getPolicyRef());
        this.withRoleBindings(instance.getRoleBindings());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public String getLastModified() {
        return this.lastModified;
    }

    @Override
    public A withLastModified(String lastModified) {
        this.lastModified = lastModified;
        return (A)this;
    }

    @Override
    public ObjectMeta getMetadata() {
        return this.metadata != null ? (ObjectMeta)this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public ClusterPolicyBindingFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public ClusterPolicyBindingFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public ClusterPolicyBindingFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public ObjectReference getPolicyRef() {
        return this.policyRef != null ? (ObjectReference)this.policyRef.build() : null;
    }

    @Override
    public A withPolicyRef(ObjectReference policyRef) {
        if (policyRef != null) {
            this.policyRef = new ObjectReferenceBuilder(policyRef);
            this._visitables.add(this.policyRef);
        }
        return (A)this;
    }

    @Override
    public ClusterPolicyBindingFluent.PolicyRefNested<A> withNewPolicyRef() {
        return new PolicyRefNestedImpl();
    }

    @Override
    public ClusterPolicyBindingFluent.PolicyRefNested<A> withNewPolicyRefLike(ObjectReference item) {
        return new PolicyRefNestedImpl(item);
    }

    @Override
    public ClusterPolicyBindingFluent.PolicyRefNested<A> editPolicyRef() {
        return this.withNewPolicyRefLike(this.getPolicyRef());
    }

    @Override
    public A addToRoleBindings(NamedClusterRoleBinding ... items) {
        for (NamedClusterRoleBinding item : items) {
            NamedClusterRoleBindingBuilder builder = new NamedClusterRoleBindingBuilder(item);
            this._visitables.add(builder);
            this.roleBindings.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromRoleBindings(NamedClusterRoleBinding ... items) {
        for (NamedClusterRoleBinding item : items) {
            NamedClusterRoleBindingBuilder builder = new NamedClusterRoleBindingBuilder(item);
            this._visitables.remove(builder);
            this.roleBindings.remove(builder);
        }
        return (A)this;
    }

    @Override
    public List<NamedClusterRoleBinding> getRoleBindings() {
        return ClusterPolicyBindingFluentImpl.build(this.roleBindings);
    }

    @Override
    public A withRoleBindings(List<NamedClusterRoleBinding> roleBindings) {
        this.roleBindings.clear();
        if (roleBindings != null) {
            for (NamedClusterRoleBinding item : roleBindings) {
                this.addToRoleBindings(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withRoleBindings(NamedClusterRoleBinding ... roleBindings) {
        this.roleBindings.clear();
        if (roleBindings != null) {
            for (NamedClusterRoleBinding item : roleBindings) {
                this.addToRoleBindings(item);
            }
        }
        return (A)this;
    }

    @Override
    public ClusterPolicyBindingFluent.RoleBindingsNested<A> addNewRoleBinding() {
        return new RoleBindingsNestedImpl();
    }

    @Override
    public ClusterPolicyBindingFluent.RoleBindingsNested<A> addNewRoleBindingLike(NamedClusterRoleBinding item) {
        return new RoleBindingsNestedImpl(item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClusterPolicyBindingFluentImpl that = (ClusterPolicyBindingFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.lastModified != null ? !this.lastModified.equals(that.lastModified) : that.lastModified != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.policyRef != null ? !this.policyRef.equals(that.policyRef) : that.policyRef != null) {
            return false;
        }
        return !(this.roleBindings != null ? !this.roleBindings.equals(that.roleBindings) : that.roleBindings != null);
    }

    public class RoleBindingsNestedImpl<N>
    extends NamedClusterRoleBindingFluentImpl<ClusterPolicyBindingFluent.RoleBindingsNested<N>>
    implements ClusterPolicyBindingFluent.RoleBindingsNested<N>,
    Nested<N> {
        private final NamedClusterRoleBindingBuilder builder;

        RoleBindingsNestedImpl() {
            this.builder = new NamedClusterRoleBindingBuilder(this);
        }

        RoleBindingsNestedImpl(NamedClusterRoleBinding item) {
            this.builder = new NamedClusterRoleBindingBuilder(this, item);
        }

        @Override
        public N endRoleBinding() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)ClusterPolicyBindingFluentImpl.this.addToRoleBindings(this.builder.build());
        }
    }

    public class PolicyRefNestedImpl<N>
    extends ObjectReferenceFluentImpl<ClusterPolicyBindingFluent.PolicyRefNested<N>>
    implements ClusterPolicyBindingFluent.PolicyRefNested<N>,
    Nested<N> {
        private final ObjectReferenceBuilder builder;

        PolicyRefNestedImpl() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        PolicyRefNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        @Override
        public N endPolicyRef() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)ClusterPolicyBindingFluentImpl.this.withPolicyRef(this.builder.build());
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<ClusterPolicyBindingFluent.MetadataNested<N>>
    implements ClusterPolicyBindingFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)ClusterPolicyBindingFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

