/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.PolicyBindingList;
import io.fabric8.openshift.api.model.PolicyBindingListFluent;
import io.fabric8.openshift.api.model.PolicyBindingListFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class PolicyBindingListBuilder
extends PolicyBindingListFluentImpl<PolicyBindingListBuilder>
implements VisitableBuilder<PolicyBindingList, PolicyBindingListBuilder> {
    PolicyBindingListFluent<?> fluent;
    Boolean validationEnabled;

    public PolicyBindingListBuilder() {
        this(true);
    }

    public PolicyBindingListBuilder(Boolean validationEnabled) {
        this(new PolicyBindingList(), validationEnabled);
    }

    public PolicyBindingListBuilder(PolicyBindingListFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public PolicyBindingListBuilder(PolicyBindingListFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new PolicyBindingList(), validationEnabled);
    }

    public PolicyBindingListBuilder(PolicyBindingListFluent<?> fluent, PolicyBindingList instance) {
        this(fluent, instance, true);
    }

    public PolicyBindingListBuilder(PolicyBindingListFluent<?> fluent, PolicyBindingList instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withItems(instance.getItems());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        this.validationEnabled = validationEnabled;
    }

    public PolicyBindingListBuilder(PolicyBindingList instance) {
        this(instance, (Boolean)true);
    }

    public PolicyBindingListBuilder(PolicyBindingList instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.validationEnabled = validationEnabled;
    }

    public PolicyBindingList build() {
        PolicyBindingList buildable = new PolicyBindingList(this.fluent.getApiVersion(), this.fluent.getItems(), this.fluent.getKind(), this.fluent.getMetadata());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PolicyBindingListBuilder that = (PolicyBindingListBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

