/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.TagEvent;
import io.fabric8.openshift.api.model.TagEventFluent;
import io.fabric8.openshift.api.model.TagEventFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class TagEventBuilder
extends TagEventFluentImpl<TagEventBuilder>
implements VisitableBuilder<TagEvent, TagEventBuilder> {
    TagEventFluent<?> fluent;
    Boolean validationEnabled;

    public TagEventBuilder() {
        this(true);
    }

    public TagEventBuilder(Boolean validationEnabled) {
        this(new TagEvent(), validationEnabled);
    }

    public TagEventBuilder(TagEventFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public TagEventBuilder(TagEventFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new TagEvent(), validationEnabled);
    }

    public TagEventBuilder(TagEventFluent<?> fluent, TagEvent instance) {
        this(fluent, instance, true);
    }

    public TagEventBuilder(TagEventFluent<?> fluent, TagEvent instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withCreated(instance.getCreated());
        fluent.withDockerImageReference(instance.getDockerImageReference());
        fluent.withGeneration(instance.getGeneration());
        fluent.withImage(instance.getImage());
        this.validationEnabled = validationEnabled;
    }

    public TagEventBuilder(TagEvent instance) {
        this(instance, (Boolean)true);
    }

    public TagEventBuilder(TagEvent instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withCreated(instance.getCreated());
        this.withDockerImageReference(instance.getDockerImageReference());
        this.withGeneration(instance.getGeneration());
        this.withImage(instance.getImage());
        this.validationEnabled = validationEnabled;
    }

    public TagEvent build() {
        TagEvent buildable = new TagEvent(this.fluent.getCreated(), this.fluent.getDockerImageReference(), this.fluent.getGeneration(), this.fluent.getImage());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TagEventBuilder that = (TagEventBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

