/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class LocalObjectReferenceBuilder
extends LocalObjectReferenceFluentImpl<LocalObjectReferenceBuilder>
implements VisitableBuilder<LocalObjectReference, LocalObjectReferenceBuilder> {
    LocalObjectReferenceFluent<?> fluent;
    Boolean validationEnabled;

    public LocalObjectReferenceBuilder() {
        this(true);
    }

    public LocalObjectReferenceBuilder(Boolean validationEnabled) {
        this(new LocalObjectReference(), validationEnabled);
    }

    public LocalObjectReferenceBuilder(LocalObjectReferenceFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public LocalObjectReferenceBuilder(LocalObjectReferenceFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new LocalObjectReference(), validationEnabled);
    }

    public LocalObjectReferenceBuilder(LocalObjectReferenceFluent<?> fluent, LocalObjectReference instance) {
        this(fluent, instance, true);
    }

    public LocalObjectReferenceBuilder(LocalObjectReferenceFluent<?> fluent, LocalObjectReference instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withName(instance.getName());
        this.validationEnabled = validationEnabled;
    }

    public LocalObjectReferenceBuilder(LocalObjectReference instance) {
        this(instance, (Boolean)true);
    }

    public LocalObjectReferenceBuilder(LocalObjectReference instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withName(instance.getName());
        this.validationEnabled = validationEnabled;
    }

    public LocalObjectReference build() {
        LocalObjectReference buildable = new LocalObjectReference(this.fluent.getName());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LocalObjectReferenceBuilder that = (LocalObjectReferenceBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

