/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.openshift.api.model.ImageSource;
import io.fabric8.openshift.api.model.ImageSourceFluent;
import io.fabric8.openshift.api.model.ImageSourcePath;
import io.fabric8.openshift.api.model.ImageSourcePathBuilder;
import io.fabric8.openshift.api.model.ImageSourcePathFluentImpl;
import java.util.ArrayList;
import java.util.List;

public class ImageSourceFluentImpl<A extends ImageSourceFluent<A>>
extends BaseFluent<A>
implements ImageSourceFluent<A> {
    private VisitableBuilder<? extends ObjectReference, ?> from;
    private List<VisitableBuilder<? extends ImageSourcePath, ?>> paths = new ArrayList();
    private VisitableBuilder<? extends LocalObjectReference, ?> pullSecret;

    public ImageSourceFluentImpl() {
    }

    public ImageSourceFluentImpl(ImageSource instance) {
        this.withFrom(instance.getFrom());
        this.withPaths(instance.getPaths());
        this.withPullSecret(instance.getPullSecret());
    }

    @Override
    public ObjectReference getFrom() {
        return this.from != null ? (ObjectReference)this.from.build() : null;
    }

    @Override
    public A withFrom(ObjectReference from) {
        if (from != null) {
            this.from = new ObjectReferenceBuilder(from);
            this._visitables.add(this.from);
        }
        return (A)this;
    }

    @Override
    public ImageSourceFluent.FromNested<A> withNewFrom() {
        return new FromNestedImpl();
    }

    @Override
    public ImageSourceFluent.FromNested<A> withNewFromLike(ObjectReference item) {
        return new FromNestedImpl(item);
    }

    @Override
    public ImageSourceFluent.FromNested<A> editFrom() {
        return this.withNewFromLike(this.getFrom());
    }

    @Override
    public A addToPaths(ImageSourcePath ... items) {
        for (ImageSourcePath item : items) {
            ImageSourcePathBuilder builder = new ImageSourcePathBuilder(item);
            this._visitables.add(builder);
            this.paths.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromPaths(ImageSourcePath ... items) {
        for (ImageSourcePath item : items) {
            ImageSourcePathBuilder builder = new ImageSourcePathBuilder(item);
            this._visitables.remove(builder);
            this.paths.remove(builder);
        }
        return (A)this;
    }

    @Override
    public List<ImageSourcePath> getPaths() {
        return ImageSourceFluentImpl.build(this.paths);
    }

    @Override
    public A withPaths(List<ImageSourcePath> paths) {
        this.paths.clear();
        if (paths != null) {
            for (ImageSourcePath item : paths) {
                this.addToPaths(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withPaths(ImageSourcePath ... paths) {
        this.paths.clear();
        if (paths != null) {
            for (ImageSourcePath item : paths) {
                this.addToPaths(item);
            }
        }
        return (A)this;
    }

    @Override
    public ImageSourceFluent.PathsNested<A> addNewPath() {
        return new PathsNestedImpl();
    }

    @Override
    public ImageSourceFluent.PathsNested<A> addNewPathLike(ImageSourcePath item) {
        return new PathsNestedImpl(item);
    }

    @Override
    public A addNewPath(String destinationDir, String sourcePath) {
        return this.addToPaths(new ImageSourcePath(destinationDir, sourcePath));
    }

    @Override
    public LocalObjectReference getPullSecret() {
        return this.pullSecret != null ? (LocalObjectReference)this.pullSecret.build() : null;
    }

    @Override
    public A withPullSecret(LocalObjectReference pullSecret) {
        if (pullSecret != null) {
            this.pullSecret = new LocalObjectReferenceBuilder(pullSecret);
            this._visitables.add(this.pullSecret);
        }
        return (A)this;
    }

    @Override
    public ImageSourceFluent.PullSecretNested<A> withNewPullSecret() {
        return new PullSecretNestedImpl();
    }

    @Override
    public ImageSourceFluent.PullSecretNested<A> withNewPullSecretLike(LocalObjectReference item) {
        return new PullSecretNestedImpl(item);
    }

    @Override
    public ImageSourceFluent.PullSecretNested<A> editPullSecret() {
        return this.withNewPullSecretLike(this.getPullSecret());
    }

    @Override
    public A withNewPullSecret(String name) {
        return this.withPullSecret(new LocalObjectReference(name));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImageSourceFluentImpl that = (ImageSourceFluentImpl)o;
        if (this.from != null ? !this.from.equals(that.from) : that.from != null) {
            return false;
        }
        if (this.paths != null ? !this.paths.equals(that.paths) : that.paths != null) {
            return false;
        }
        return !(this.pullSecret != null ? !this.pullSecret.equals(that.pullSecret) : that.pullSecret != null);
    }

    public class PullSecretNestedImpl<N>
    extends LocalObjectReferenceFluentImpl<ImageSourceFluent.PullSecretNested<N>>
    implements ImageSourceFluent.PullSecretNested<N>,
    Nested<N> {
        private final LocalObjectReferenceBuilder builder;

        PullSecretNestedImpl() {
            this.builder = new LocalObjectReferenceBuilder(this);
        }

        PullSecretNestedImpl(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ImageSourceFluentImpl.this.withPullSecret(this.builder.build());
        }

        @Override
        public N endPullSecret() {
            return this.and();
        }
    }

    public class PathsNestedImpl<N>
    extends ImageSourcePathFluentImpl<ImageSourceFluent.PathsNested<N>>
    implements ImageSourceFluent.PathsNested<N>,
    Nested<N> {
        private final ImageSourcePathBuilder builder;

        PathsNestedImpl() {
            this.builder = new ImageSourcePathBuilder(this);
        }

        PathsNestedImpl(ImageSourcePath item) {
            this.builder = new ImageSourcePathBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ImageSourceFluentImpl.this.addToPaths(this.builder.build());
        }

        @Override
        public N endPath() {
            return this.and();
        }
    }

    public class FromNestedImpl<N>
    extends ObjectReferenceFluentImpl<ImageSourceFluent.FromNested<N>>
    implements ImageSourceFluent.FromNested<N>,
    Nested<N> {
        private final ObjectReferenceBuilder builder;

        FromNestedImpl() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        FromNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        @Override
        public N endFrom() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)ImageSourceFluentImpl.this.withFrom(this.builder.build());
        }
    }
}

