/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ResourceQuota;
import io.fabric8.kubernetes.api.model.ResourceQuotaSpec;
import io.fabric8.kubernetes.api.model.ResourceQuotaSpecBuilder;
import io.fabric8.kubernetes.api.model.ResourceQuotaSpecFluent;
import io.fabric8.kubernetes.api.model.ResourceQuotaStatus;
import java.util.HashMap;
import java.util.Map;

public class ResourceQuotaFluent<T extends ResourceQuotaFluent<T>>
extends BaseFluent<T>
implements Fluent<T> {
    ResourceQuota.ApiVersion apiVersion;
    String kind;
    VisitableBuilder<ObjectMeta, ?> metadata;
    VisitableBuilder<ResourceQuotaSpec, ?> spec;
    ResourceQuotaStatus status;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public ResourceQuota.ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    public T withApiVersion(ResourceQuota.ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
        return (T)((Object)this);
    }

    public String getKind() {
        return this.kind;
    }

    public T withKind(String kind) {
        this.kind = kind;
        return (T)((Object)this);
    }

    public ObjectMeta getMetadata() {
        return this.metadata != null ? (ObjectMeta)this.metadata.build() : null;
    }

    public T withMetadata(ObjectMeta metadata) {
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (T)((Object)this);
    }

    public MetadataNested<T> withNewMetadata() {
        return new MetadataNested();
    }

    public MetadataNested<T> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<T> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    public ResourceQuotaSpec getSpec() {
        return this.spec != null ? (ResourceQuotaSpec)this.spec.build() : null;
    }

    public T withSpec(ResourceQuotaSpec spec) {
        if (spec != null) {
            this.spec = new ResourceQuotaSpecBuilder(spec);
            this._visitables.add(this.spec);
        }
        return (T)((Object)this);
    }

    public SpecNested<T> withNewSpec() {
        return new SpecNested();
    }

    public SpecNested<T> withNewSpecLike(ResourceQuotaSpec item) {
        return new SpecNested(item);
    }

    public SpecNested<T> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    public ResourceQuotaStatus getStatus() {
        return this.status;
    }

    public T withStatus(ResourceQuotaStatus status) {
        this.status = status;
        return (T)((Object)this);
    }

    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)((Object)this);
    }

    public class SpecNested<N>
    extends ResourceQuotaSpecFluent<SpecNested<N>>
    implements Nested<N> {
        private final ResourceQuotaSpecBuilder builder;

        SpecNested() {
            this.builder = new ResourceQuotaSpecBuilder(this);
        }

        SpecNested(ResourceQuotaSpec item) {
            this.builder = new ResourceQuotaSpecBuilder(this, item);
        }

        public N endSpec() {
            return this.and();
        }

        public N and() {
            return (N)ResourceQuotaFluent.this.withSpec(this.builder.build());
        }
    }

    public class MetadataNested<N>
    extends ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNested() {
            this.builder = new ObjectMetaBuilder(this);
        }

        MetadataNested(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        public N endMetadata() {
            return this.and();
        }

        public N and() {
            return (N)ResourceQuotaFluent.this.withMetadata(this.builder.build());
        }
    }
}

