/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.GenericWebHookCause;
import io.fabric8.openshift.api.model.GenericWebHookCauseFluent;
import io.fabric8.openshift.api.model.GenericWebHookCauseFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class GenericWebHookCauseBuilder
extends GenericWebHookCauseFluentImpl<GenericWebHookCauseBuilder>
implements VisitableBuilder<GenericWebHookCause, GenericWebHookCauseBuilder> {
    GenericWebHookCauseFluent<?> fluent;
    Boolean validationEnabled;

    public GenericWebHookCauseBuilder() {
        this(true);
    }

    public GenericWebHookCauseBuilder(Boolean validationEnabled) {
        this(new GenericWebHookCause(), validationEnabled);
    }

    public GenericWebHookCauseBuilder(GenericWebHookCauseFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public GenericWebHookCauseBuilder(GenericWebHookCauseFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new GenericWebHookCause(), validationEnabled);
    }

    public GenericWebHookCauseBuilder(GenericWebHookCauseFluent<?> fluent, GenericWebHookCause instance) {
        this(fluent, instance, true);
    }

    public GenericWebHookCauseBuilder(GenericWebHookCauseFluent<?> fluent, GenericWebHookCause instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withRevision(instance.getRevision());
        fluent.withSecret(instance.getSecret());
        this.validationEnabled = validationEnabled;
    }

    public GenericWebHookCauseBuilder(GenericWebHookCause instance) {
        this(instance, (Boolean)true);
    }

    public GenericWebHookCauseBuilder(GenericWebHookCause instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withRevision(instance.getRevision());
        this.withSecret(instance.getSecret());
        this.validationEnabled = validationEnabled;
    }

    public GenericWebHookCause build() {
        GenericWebHookCause buildable = new GenericWebHookCause(this.fluent.getRevision(), this.fluent.getSecret());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GenericWebHookCauseBuilder that = (GenericWebHookCauseBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

