/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.assertions;

import io.fabric8.kubernetes.api.Controller;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodAssert;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerAssert;
import io.fabric8.kubernetes.api.model.ReplicationControllerList;
import io.fabric8.kubernetes.api.model.ReplicationControllerListAssert;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceAssert;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.api.model.ServiceListAssert;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServiceSpec;
import io.fabric8.kubernetes.api.model.ServiceSpecAssert;
import io.fabric8.kubernetes.api.model.extensions.Deployment;
import io.fabric8.kubernetes.api.model.extensions.DeploymentAssert;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSet;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetAssert;
import io.fabric8.kubernetes.assertions.Assertions;
import io.fabric8.kubernetes.assertions.DeploymentConfigPodsAssert;
import io.fabric8.kubernetes.assertions.DeploymentPodsAssert;
import io.fabric8.kubernetes.assertions.HasPodSelectionAssert;
import io.fabric8.kubernetes.assertions.KubernetesNamespaceAssert;
import io.fabric8.kubernetes.assertions.PodsAssert;
import io.fabric8.kubernetes.assertions.ReplicaSetPodsAssert;
import io.fabric8.kubernetes.assertions.ReplicationControllerPodsAssert;
import io.fabric8.kubernetes.assertions.ServicePodsAssert;
import io.fabric8.kubernetes.assertions.ServicesAssert;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ClientPodResource;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import io.fabric8.kubernetes.client.dsl.ClientRollableScallableResource;
import io.fabric8.kubernetes.client.dsl.ClientScaleableResource;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.DeploymentConfigAssert;
import io.fabric8.openshift.client.OpenShiftClient;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.ListAssert;

public class KubernetesAssert
extends AbstractAssert<KubernetesAssert, KubernetesClient> {
    private final KubernetesClient client;

    public KubernetesAssert(KubernetesClient client) {
        super((Object)client, KubernetesAssert.class);
        this.client = client;
    }

    public KubernetesNamespaceAssert namespace(String namespace) {
        return new KubernetesNamespaceAssert(this.client, namespace);
    }

    public HasPodSelectionAssert deployments() {
        ArrayList<HasPodSelectionAssert> asserters = new ArrayList<HasPodSelectionAssert>();
        List resources = new ArrayList();
        try {
            resources = KubernetesHelper.findKubernetesResourcesOnClasspath((Controller)new Controller(this.client));
        }
        catch (IOException e) {
            org.assertj.core.api.Assertions.fail((String)("Failed to load kubernetes resources on the classpath: " + e), (Throwable)e);
        }
        for (HasMetadata resource : resources) {
            HasPodSelectionAssert asserter = this.createPodSelectionAssert(resource);
            if (asserter == null) continue;
            asserters.add(asserter);
        }
        String message = "No pod selection kinds found on the classpath such as Deployment, DeploymentConfig, ReplicaSet, ReplicationController";
        ((AbstractListAssert)org.assertj.core.api.Assertions.assertThat(asserters).describedAs(message, new Object[0]).isNotEmpty()).hasSize(1);
        return (HasPodSelectionAssert)asserters.get(0);
    }

    protected HasPodSelectionAssert createPodSelectionAssert(HasMetadata resource) {
        if (resource instanceof DeploymentConfig) {
            DeploymentConfig deployment = (DeploymentConfig)resource;
            return new DeploymentConfigPodsAssert(this.client, deployment);
        }
        if (resource instanceof Deployment) {
            Deployment deployment = (Deployment)resource;
            return new DeploymentPodsAssert(this.client, deployment);
        }
        if (resource instanceof ReplicaSet) {
            ReplicaSet replica = (ReplicaSet)resource;
            return new ReplicaSetPodsAssert(this.client, replica);
        }
        if (resource instanceof ReplicationController) {
            ReplicationController replica = (ReplicationController)resource;
            return new ReplicationControllerPodsAssert(this.client, replica);
        }
        return null;
    }

    public HasPodSelectionAssert deployment(String deploymentName) {
        String namespace = this.namespace();
        String qualifiedName = namespace + "." + deploymentName;
        OpenShiftClient openShiftClient = new Controller(this.client).getOpenShiftClientOrNull();
        if (openShiftClient != null) {
            DeploymentConfig deployment = (DeploymentConfig)((ClientScaleableResource)((ClientNonNamespaceOperation)openShiftClient.deploymentConfigs().inNamespace(namespace)).withName(deploymentName)).get();
            ((DeploymentConfigAssert)((DeploymentConfigAssert)Assertions.assertThat(deployment).describedAs("DeploymentConfig: " + qualifiedName, new Object[0])).isNotNull()).metadata().name().isEqualTo((Object)deploymentName);
            return new DeploymentConfigPodsAssert(this.client, deployment);
        }
        Deployment deployment = (Deployment)((ClientScaleableResource)((ClientNonNamespaceOperation)this.client.extensions().deployments().inNamespace(namespace)).withName(deploymentName)).get();
        ((DeploymentAssert)((DeploymentAssert)Assertions.assertThat(deployment).describedAs("Deployment: " + qualifiedName, new Object[0])).isNotNull()).metadata().name().isEqualTo((Object)deploymentName);
        return new DeploymentPodsAssert(this.client, deployment);
    }

    public String namespace() {
        return this.client.getNamespace();
    }

    public HasPodSelectionAssert replicas(String replicaName) {
        String namespace = this.namespace();
        String qualifiedName = namespace + "." + replicaName;
        ReplicaSet replicasSet = (ReplicaSet)((ClientRollableScallableResource)this.client.extensions().replicaSets().withName(replicaName)).get();
        if (replicasSet != null) {
            ((ReplicaSetAssert)Assertions.assertThat(replicasSet).describedAs("ReplicaSet: " + qualifiedName, new Object[0])).metadata().name().isEqualTo((Object)replicaName);
            return new ReplicaSetPodsAssert(this.client, replicasSet);
        }
        ReplicationController replicationController = (ReplicationController)((ClientRollableScallableResource)this.client.replicationControllers().withName(replicaName)).get();
        ((ReplicationControllerAssert)Assertions.assertThat(replicationController).describedAs("No ReplicaSet or ReplicationController called: " + qualifiedName, new Object[0])).isNotNull();
        ((ReplicationControllerAssert)Assertions.assertThat(replicationController).describedAs("ReplicationController: " + qualifiedName, new Object[0])).metadata().name().isEqualTo((Object)replicaName);
        return new ReplicationControllerPodsAssert(this.client, replicationController);
    }

    public PodsAssert podList() {
        PodList pods = (PodList)((ClientNonNamespaceOperation)this.client.pods().inNamespace(this.namespace())).list();
        return this.podList(pods);
    }

    public PodsAssert podList(PodList pods) {
        Assertions.assertThat(pods).isNotNull();
        return this.podList(pods.getItems());
    }

    public PodsAssert podList(List<Pod> pods) {
        org.assertj.core.api.Assertions.assertThat(pods).isNotNull();
        return new PodsAssert(pods, this.client);
    }

    public PodsAssert pods() {
        List<Pod> pods = this.getPods(this.namespace());
        return this.podList(pods);
    }

    protected List<Pod> getPods(String namespace) {
        PodList podList = (PodList)((ClientNonNamespaceOperation)this.client.pods().inNamespace(namespace)).list();
        Assertions.assertThat(podList).isNotNull();
        List<Pod> pods = podList.getItems();
        this.podList(pods).isNotNull();
        return pods;
    }

    public ReplicationControllerListAssert replicationControllerList() {
        ReplicationControllerList replicationControllers = (ReplicationControllerList)this.client.replicationControllers().list();
        return (ReplicationControllerListAssert)Assertions.assertThat(replicationControllers).isNotNull();
    }

    public ListAssert<ReplicationController> replicationControllers() {
        ReplicationControllerList replicationControllerList = (ReplicationControllerList)((ClientNonNamespaceOperation)this.client.replicationControllers().inNamespace(this.namespace())).list();
        Assertions.assertThat(replicationControllerList).isNotNull();
        List<ReplicationController> replicationControllers = replicationControllerList.getItems();
        return (ListAssert)org.assertj.core.api.Assertions.assertThat(replicationControllers);
    }

    public ServiceListAssert serviceList() {
        ServiceList serviceList = (ServiceList)((ClientNonNamespaceOperation)this.client.services().inNamespace(this.namespace())).list();
        return (ServiceListAssert)Assertions.assertThat(serviceList).isNotNull();
    }

    public ServicesAssert services() {
        ServiceList serviceList = (ServiceList)((ClientNonNamespaceOperation)this.client.services().inNamespace(this.namespace())).list();
        Assertions.assertThat(serviceList).isNotNull();
        List<Service> services = serviceList.getItems();
        return new ServicesAssert(this.client, services);
    }

    public ServicePodsAssert service(String serviceName) {
        Service service = (Service)((ClientResource)((ClientNonNamespaceOperation)this.client.services().inNamespace(this.namespace())).withName(serviceName)).get();
        ((ServiceAssert)Assertions.assertThat(service).describedAs("No service exists for name: " + serviceName, new Object[0])).isNotNull();
        return new ServicePodsAssert(this.client, service);
    }

    public PodsAssert podsForReplicationController(String replicationControllerName) {
        ReplicationController replicationController = this.getReplicationController(replicationControllerName, this.namespace());
        return this.podsForReplicationController(replicationController);
    }

    public PodsAssert podsForReplicationController(ReplicationController replicationController) {
        List<Pod> allPods = this.getPods(replicationController.getMetadata().getNamespace());
        List pods = KubernetesHelper.getPodsForReplicationController((ReplicationController)replicationController, allPods);
        return this.podList(pods);
    }

    public PodsAssert podsForService(String serviceName) {
        Service service = this.getService(serviceName, this.namespace());
        return this.podsForService(service);
    }

    public PodsAssert podsForService(Service service) {
        List<Pod> allPods = this.getPods(service.getMetadata().getNamespace());
        List pods = KubernetesHelper.getPodsForService((Service)service, allPods);
        return this.podList(pods);
    }

    public ReplicationControllerAssert replicationController(String replicationControllerName) {
        return Assertions.assertThat(this.getReplicationController(replicationControllerName, this.namespace()));
    }

    protected ReplicationController getReplicationController(String replicationControllerId, String namespace) {
        org.assertj.core.api.Assertions.assertThat((String)replicationControllerId).isNotNull();
        ReplicationController replicationController = null;
        try {
            replicationController = (ReplicationController)((ClientRollableScallableResource)((ClientNonNamespaceOperation)this.client.replicationControllers().inNamespace(namespace)).withName(replicationControllerId)).get();
        }
        catch (Exception e) {
            org.assertj.core.api.Assertions.fail((String)("Could not find replicationController for '" + replicationControllerId + "'"));
        }
        Assertions.assertThat(replicationController).isNotNull();
        return replicationController;
    }

    public void hasServicePort(String serviceId, int port) {
        ServiceSpec spec = this.getServiceSpec(serviceId, this.namespace());
        boolean found = false;
        List<ServicePort> ports = spec.getPorts();
        ArrayList<Integer> portNumbers = new ArrayList<Integer>();
        if (ports != null) {
            for (ServicePort servicePort : ports) {
                Integer aPort = servicePort.getPort();
                if (aPort == null) continue;
                if (aPort == port) {
                    found = true;
                    break;
                }
                portNumbers.add(aPort);
            }
        }
        ((AbstractBooleanAssert)org.assertj.core.api.Assertions.assertThat((boolean)found).describedAs("No port found for " + port + " but found ports: " + portNumbers, new Object[0])).isTrue();
    }

    public ServiceSpecAssert serviceSpec(String serviceName) {
        return Assertions.assertThat(this.getServiceSpec(serviceName, this.namespace()));
    }

    protected Service getService(String serviceId, String namespace) {
        org.assertj.core.api.Assertions.assertThat((String)serviceId).isNotNull();
        Service service = null;
        try {
            service = (Service)((ClientResource)((ClientNonNamespaceOperation)this.client.services().inNamespace(namespace)).withName(serviceId)).get();
        }
        catch (Exception e) {
            org.assertj.core.api.Assertions.fail((String)("Could not find service for '" + serviceId + "'"));
        }
        Assertions.assertThat(service).isNotNull();
        return service;
    }

    protected ServiceSpec getServiceSpec(String serviceId, String namespace) {
        Service service = this.getService(serviceId, namespace);
        ServiceSpec spec = service.getSpec();
        Assertions.assertThat(spec).isNotNull();
        return spec;
    }

    public PodAssert pod(String podName) {
        return Assertions.assertThat(this.getPod(podName, this.namespace()));
    }

    protected Pod getPod(String podId, String namespace) {
        org.assertj.core.api.Assertions.assertThat((String)podId).isNotNull();
        Pod pod = null;
        try {
            pod = (Pod)((ClientPodResource)((ClientNonNamespaceOperation)this.client.pods().inNamespace(namespace)).withName(podId)).get();
        }
        catch (Exception e) {
            org.assertj.core.api.Assertions.fail((String)("Could not find pod for '" + podId + "'"));
        }
        Assertions.assertThat(pod).isNotNull();
        return pod;
    }
}

