/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.openshift.api.model.NamedRoleBinding;
import io.fabric8.openshift.api.model.NamedRoleBindingBuilder;
import io.fabric8.openshift.api.model.NamedRoleBindingFluentImpl;
import io.fabric8.openshift.api.model.PolicyBinding;
import io.fabric8.openshift.api.model.PolicyBindingFluent;
import java.util.ArrayList;
import java.util.List;

public class PolicyBindingFluentImpl<A extends PolicyBindingFluent<A>>
extends BaseFluent<A>
implements PolicyBindingFluent<A> {
    private String apiVersion;
    private String kind;
    private String lastModified;
    private VisitableBuilder<? extends ObjectMeta, ?> metadata;
    private VisitableBuilder<? extends ObjectReference, ?> policyRef;
    private List<VisitableBuilder<? extends NamedRoleBinding, ?>> roleBindings = new ArrayList();

    public PolicyBindingFluentImpl() {
    }

    public PolicyBindingFluentImpl(PolicyBinding instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withLastModified(instance.getLastModified());
        this.withMetadata(instance.getMetadata());
        this.withPolicyRef(instance.getPolicyRef());
        this.withRoleBindings(instance.getRoleBindings());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public String getLastModified() {
        return this.lastModified;
    }

    @Override
    public A withLastModified(String lastModified) {
        this.lastModified = lastModified;
        return (A)this;
    }

    @Override
    public ObjectMeta getMetadata() {
        return this.metadata != null ? (ObjectMeta)this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public PolicyBindingFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public PolicyBindingFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public PolicyBindingFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public ObjectReference getPolicyRef() {
        return this.policyRef != null ? (ObjectReference)this.policyRef.build() : null;
    }

    @Override
    public A withPolicyRef(ObjectReference policyRef) {
        if (policyRef != null) {
            this.policyRef = new ObjectReferenceBuilder(policyRef);
            this._visitables.add(this.policyRef);
        }
        return (A)this;
    }

    @Override
    public PolicyBindingFluent.PolicyRefNested<A> withNewPolicyRef() {
        return new PolicyRefNestedImpl();
    }

    @Override
    public PolicyBindingFluent.PolicyRefNested<A> withNewPolicyRefLike(ObjectReference item) {
        return new PolicyRefNestedImpl(item);
    }

    @Override
    public PolicyBindingFluent.PolicyRefNested<A> editPolicyRef() {
        return this.withNewPolicyRefLike(this.getPolicyRef());
    }

    @Override
    public A addToRoleBindings(NamedRoleBinding ... items) {
        for (NamedRoleBinding item : items) {
            NamedRoleBindingBuilder builder = new NamedRoleBindingBuilder(item);
            this._visitables.add(builder);
            this.roleBindings.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromRoleBindings(NamedRoleBinding ... items) {
        for (NamedRoleBinding item : items) {
            NamedRoleBindingBuilder builder = new NamedRoleBindingBuilder(item);
            this._visitables.remove(builder);
            this.roleBindings.remove(builder);
        }
        return (A)this;
    }

    @Override
    public List<NamedRoleBinding> getRoleBindings() {
        return PolicyBindingFluentImpl.build(this.roleBindings);
    }

    @Override
    public A withRoleBindings(List<NamedRoleBinding> roleBindings) {
        this.roleBindings.clear();
        if (roleBindings != null) {
            for (NamedRoleBinding item : roleBindings) {
                this.addToRoleBindings(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withRoleBindings(NamedRoleBinding ... roleBindings) {
        this.roleBindings.clear();
        if (roleBindings != null) {
            for (NamedRoleBinding item : roleBindings) {
                this.addToRoleBindings(item);
            }
        }
        return (A)this;
    }

    @Override
    public PolicyBindingFluent.RoleBindingsNested<A> addNewRoleBinding() {
        return new RoleBindingsNestedImpl();
    }

    @Override
    public PolicyBindingFluent.RoleBindingsNested<A> addNewRoleBindingLike(NamedRoleBinding item) {
        return new RoleBindingsNestedImpl(item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PolicyBindingFluentImpl that = (PolicyBindingFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.lastModified != null ? !this.lastModified.equals(that.lastModified) : that.lastModified != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.policyRef != null ? !this.policyRef.equals(that.policyRef) : that.policyRef != null) {
            return false;
        }
        return !(this.roleBindings != null ? !this.roleBindings.equals(that.roleBindings) : that.roleBindings != null);
    }

    public class RoleBindingsNestedImpl<N>
    extends NamedRoleBindingFluentImpl<PolicyBindingFluent.RoleBindingsNested<N>>
    implements PolicyBindingFluent.RoleBindingsNested<N>,
    Nested<N> {
        private final NamedRoleBindingBuilder builder;

        RoleBindingsNestedImpl() {
            this.builder = new NamedRoleBindingBuilder(this);
        }

        RoleBindingsNestedImpl(NamedRoleBinding item) {
            this.builder = new NamedRoleBindingBuilder(this, item);
        }

        @Override
        public N endRoleBinding() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)PolicyBindingFluentImpl.this.addToRoleBindings(this.builder.build());
        }
    }

    public class PolicyRefNestedImpl<N>
    extends ObjectReferenceFluentImpl<PolicyBindingFluent.PolicyRefNested<N>>
    implements PolicyBindingFluent.PolicyRefNested<N>,
    Nested<N> {
        private final ObjectReferenceBuilder builder;

        PolicyRefNestedImpl() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        PolicyRefNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        @Override
        public N endPolicyRef() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)PolicyBindingFluentImpl.this.withPolicyRef(this.builder.build());
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<PolicyBindingFluent.MetadataNested<N>>
    implements PolicyBindingFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)PolicyBindingFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

