/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.assertions;

import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.extensions.Deployment;
import io.fabric8.kubernetes.api.model.extensions.DeploymentAssert;
import io.fabric8.kubernetes.api.model.extensions.DeploymentSpec;
import io.fabric8.kubernetes.api.model.extensions.DeploymentSpecAssert;
import io.fabric8.kubernetes.api.model.extensions.LabelSelector;
import io.fabric8.kubernetes.api.model.extensions.LabelSelectorRequirement;
import io.fabric8.kubernetes.assertions.HasPodSelectionAssert;
import io.fabric8.kubernetes.assertions.PodSelectionAssert;
import io.fabric8.kubernetes.client.KubernetesClient;
import java.util.List;
import java.util.Map;

public class DeploymentPodsAssert
extends DeploymentAssert
implements HasPodSelectionAssert {
    private final KubernetesClient client;

    public DeploymentPodsAssert(KubernetesClient client, Deployment deployment) {
        super(deployment);
        this.client = client;
    }

    @Override
    public PodSelectionAssert pods() {
        ((DeploymentSpecAssert)this.spec().isNotNull()).selector().isNotNull();
        DeploymentSpec spec = ((Deployment)this.actual).getSpec();
        Integer replicas = spec.getReplicas();
        LabelSelector selector = spec.getSelector();
        Map<String, String> matchLabels = selector.getMatchLabels();
        List<LabelSelectorRequirement> matchExpressions = selector.getMatchExpressions();
        return new PodSelectionAssert(this.client, replicas, matchLabels, matchExpressions, "DeploymentConfig " + KubernetesHelper.getName((HasMetadata)((HasMetadata)this.actual)));
    }
}

