/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.DeleteOptions;
import io.fabric8.kubernetes.api.model.DeleteOptionsFluent;
import io.fabric8.kubernetes.api.model.DeleteOptionsFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class DeleteOptionsBuilder
extends DeleteOptionsFluentImpl<DeleteOptionsBuilder>
implements VisitableBuilder<DeleteOptions, DeleteOptionsBuilder> {
    DeleteOptionsFluent<?> fluent;
    Boolean validationEnabled;

    public DeleteOptionsBuilder() {
        this(true);
    }

    public DeleteOptionsBuilder(Boolean validationEnabled) {
        this(new DeleteOptions(), validationEnabled);
    }

    public DeleteOptionsBuilder(DeleteOptionsFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public DeleteOptionsBuilder(DeleteOptionsFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new DeleteOptions(), validationEnabled);
    }

    public DeleteOptionsBuilder(DeleteOptionsFluent<?> fluent, DeleteOptions instance) {
        this(fluent, instance, true);
    }

    public DeleteOptionsBuilder(DeleteOptionsFluent<?> fluent, DeleteOptions instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withGracePeriodSeconds(instance.getGracePeriodSeconds());
        fluent.withKind(instance.getKind());
        fluent.withOrphanDependents(instance.getOrphanDependents());
        fluent.withPreconditions(instance.getPreconditions());
        this.validationEnabled = validationEnabled;
    }

    public DeleteOptionsBuilder(DeleteOptions instance) {
        this(instance, (Boolean)true);
    }

    public DeleteOptionsBuilder(DeleteOptions instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withGracePeriodSeconds(instance.getGracePeriodSeconds());
        this.withKind(instance.getKind());
        this.withOrphanDependents(instance.getOrphanDependents());
        this.withPreconditions(instance.getPreconditions());
        this.validationEnabled = validationEnabled;
    }

    public DeleteOptions build() {
        DeleteOptions buildable = new DeleteOptions(this.fluent.getApiVersion(), this.fluent.getGracePeriodSeconds(), this.fluent.getKind(), this.fluent.isOrphanDependents(), this.fluent.getPreconditions());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeleteOptionsBuilder that = (DeleteOptionsBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

