/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.AuthInfo;
import io.fabric8.kubernetes.api.model.AuthInfoFluent;
import io.fabric8.kubernetes.api.model.AuthProviderConfig;
import io.fabric8.kubernetes.api.model.AuthProviderConfigBuilder;
import io.fabric8.kubernetes.api.model.AuthProviderConfigFluentImpl;
import io.fabric8.kubernetes.api.model.NamedExtension;
import io.fabric8.kubernetes.api.model.NamedExtensionBuilder;
import io.fabric8.kubernetes.api.model.NamedExtensionFluentImpl;
import java.util.ArrayList;
import java.util.List;

public class AuthInfoFluentImpl<A extends AuthInfoFluent<A>>
extends BaseFluent<A>
implements AuthInfoFluent<A> {
    private String as;
    private VisitableBuilder<? extends AuthProviderConfig, ?> authProvider;
    private String clientCertificate;
    private String clientCertificateData;
    private String clientKey;
    private String clientKeyData;
    private List<VisitableBuilder<? extends NamedExtension, ?>> extensions = new ArrayList();
    private String password;
    private String token;
    private String username;

    public AuthInfoFluentImpl() {
    }

    public AuthInfoFluentImpl(AuthInfo instance) {
        this.withAs(instance.getAs());
        this.withAuthProvider(instance.getAuthProvider());
        this.withClientCertificate(instance.getClientCertificate());
        this.withClientCertificateData(instance.getClientCertificateData());
        this.withClientKey(instance.getClientKey());
        this.withClientKeyData(instance.getClientKeyData());
        this.withExtensions(instance.getExtensions());
        this.withPassword(instance.getPassword());
        this.withToken(instance.getToken());
        this.withUsername(instance.getUsername());
    }

    @Override
    public String getAs() {
        return this.as;
    }

    @Override
    public A withAs(String as) {
        this.as = as;
        return (A)this;
    }

    @Override
    public AuthProviderConfig getAuthProvider() {
        return this.authProvider != null ? (AuthProviderConfig)this.authProvider.build() : null;
    }

    @Override
    public A withAuthProvider(AuthProviderConfig authProvider) {
        if (authProvider != null) {
            this.authProvider = new AuthProviderConfigBuilder(authProvider);
            this._visitables.add(this.authProvider);
        }
        return (A)this;
    }

    @Override
    public AuthInfoFluent.AuthProviderNested<A> withNewAuthProvider() {
        return new AuthProviderNestedImpl();
    }

    @Override
    public AuthInfoFluent.AuthProviderNested<A> withNewAuthProviderLike(AuthProviderConfig item) {
        return new AuthProviderNestedImpl(item);
    }

    @Override
    public AuthInfoFluent.AuthProviderNested<A> editAuthProvider() {
        return this.withNewAuthProviderLike(this.getAuthProvider());
    }

    @Override
    public String getClientCertificate() {
        return this.clientCertificate;
    }

    @Override
    public A withClientCertificate(String clientCertificate) {
        this.clientCertificate = clientCertificate;
        return (A)this;
    }

    @Override
    public String getClientCertificateData() {
        return this.clientCertificateData;
    }

    @Override
    public A withClientCertificateData(String clientCertificateData) {
        this.clientCertificateData = clientCertificateData;
        return (A)this;
    }

    @Override
    public String getClientKey() {
        return this.clientKey;
    }

    @Override
    public A withClientKey(String clientKey) {
        this.clientKey = clientKey;
        return (A)this;
    }

    @Override
    public String getClientKeyData() {
        return this.clientKeyData;
    }

    @Override
    public A withClientKeyData(String clientKeyData) {
        this.clientKeyData = clientKeyData;
        return (A)this;
    }

    @Override
    public A addToExtensions(NamedExtension ... items) {
        for (NamedExtension item : items) {
            NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
            this._visitables.add(builder);
            this.extensions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromExtensions(NamedExtension ... items) {
        for (NamedExtension item : items) {
            NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
            this._visitables.remove(builder);
            this.extensions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public List<NamedExtension> getExtensions() {
        return AuthInfoFluentImpl.build(this.extensions);
    }

    @Override
    public A withExtensions(List<NamedExtension> extensions) {
        this.extensions.clear();
        if (extensions != null) {
            for (NamedExtension item : extensions) {
                this.addToExtensions(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withExtensions(NamedExtension ... extensions) {
        this.extensions.clear();
        if (extensions != null) {
            for (NamedExtension item : extensions) {
                this.addToExtensions(item);
            }
        }
        return (A)this;
    }

    @Override
    public AuthInfoFluent.ExtensionsNested<A> addNewExtension() {
        return new ExtensionsNestedImpl();
    }

    @Override
    public AuthInfoFluent.ExtensionsNested<A> addNewExtensionLike(NamedExtension item) {
        return new ExtensionsNestedImpl(item);
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public A withPassword(String password) {
        this.password = password;
        return (A)this;
    }

    @Override
    public String getToken() {
        return this.token;
    }

    @Override
    public A withToken(String token) {
        this.token = token;
        return (A)this;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public A withUsername(String username) {
        this.username = username;
        return (A)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AuthInfoFluentImpl that = (AuthInfoFluentImpl)o;
        if (this.as != null ? !this.as.equals(that.as) : that.as != null) {
            return false;
        }
        if (this.authProvider != null ? !this.authProvider.equals(that.authProvider) : that.authProvider != null) {
            return false;
        }
        if (this.clientCertificate != null ? !this.clientCertificate.equals(that.clientCertificate) : that.clientCertificate != null) {
            return false;
        }
        if (this.clientCertificateData != null ? !this.clientCertificateData.equals(that.clientCertificateData) : that.clientCertificateData != null) {
            return false;
        }
        if (this.clientKey != null ? !this.clientKey.equals(that.clientKey) : that.clientKey != null) {
            return false;
        }
        if (this.clientKeyData != null ? !this.clientKeyData.equals(that.clientKeyData) : that.clientKeyData != null) {
            return false;
        }
        if (this.extensions != null ? !this.extensions.equals(that.extensions) : that.extensions != null) {
            return false;
        }
        if (this.password != null ? !this.password.equals(that.password) : that.password != null) {
            return false;
        }
        if (this.token != null ? !this.token.equals(that.token) : that.token != null) {
            return false;
        }
        return !(this.username != null ? !this.username.equals(that.username) : that.username != null);
    }

    public class ExtensionsNestedImpl<N>
    extends NamedExtensionFluentImpl<AuthInfoFluent.ExtensionsNested<N>>
    implements AuthInfoFluent.ExtensionsNested<N>,
    Nested<N> {
        private final NamedExtensionBuilder builder;

        ExtensionsNestedImpl() {
            this.builder = new NamedExtensionBuilder(this);
        }

        ExtensionsNestedImpl(NamedExtension item) {
            this.builder = new NamedExtensionBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)AuthInfoFluentImpl.this.addToExtensions(this.builder.build());
        }

        @Override
        public N endExtension() {
            return this.and();
        }
    }

    public class AuthProviderNestedImpl<N>
    extends AuthProviderConfigFluentImpl<AuthInfoFluent.AuthProviderNested<N>>
    implements AuthInfoFluent.AuthProviderNested<N>,
    Nested<N> {
        private final AuthProviderConfigBuilder builder;

        AuthProviderNestedImpl(AuthProviderConfig item) {
            this.builder = new AuthProviderConfigBuilder(this, item);
        }

        AuthProviderNestedImpl() {
            this.builder = new AuthProviderConfigBuilder(this);
        }

        @Override
        public N and() {
            return (N)AuthInfoFluentImpl.this.withAuthProvider(this.builder.build());
        }

        @Override
        public N endAuthProvider() {
            return this.and();
        }
    }
}

