/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.model.Config;
import io.fabric8.kubernetes.api.model.NamedAuthInfo;
import io.fabric8.kubernetes.api.model.NamedAuthInfoAssert;
import io.fabric8.kubernetes.api.model.NamedCluster;
import io.fabric8.kubernetes.api.model.NamedClusterAssert;
import io.fabric8.kubernetes.api.model.NamedContext;
import io.fabric8.kubernetes.api.model.NamedContextAssert;
import io.fabric8.kubernetes.api.model.NamedExtension;
import io.fabric8.kubernetes.api.model.NamedExtensionAssert;
import io.fabric8.kubernetes.api.model.PreferencesAssert;
import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.StringAssert;

public abstract class AbstractConfigAssert<S extends AbstractConfigAssert<S, A>, A extends Config>
extends AbstractAssert<S, A> {
    protected AbstractConfigAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public MapAssert additionalProperties() {
        this.isNotNull();
        return (MapAssert)Assertions.assertThat(((Config)this.actual).getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"), new Object[0]);
    }

    public StringAssert apiVersion() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((Config)this.actual).getApiVersion()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "apiVersion"), new Object[0]);
    }

    public NavigationListAssert<NamedCluster, NamedClusterAssert> clusters() {
        this.isNotNull();
        AssertFactory<NamedCluster, NamedClusterAssert> assertFactory = new AssertFactory<NamedCluster, NamedClusterAssert>(){

            @Override
            public NamedClusterAssert createAssert(NamedCluster t) {
                return io.fabric8.openshift.assertions.Assertions.assertThat(t);
            }
        };
        NavigationListAssert<NamedCluster, NamedClusterAssert> answer = new NavigationListAssert<NamedCluster, NamedClusterAssert>(((Config)this.actual).getClusters(), assertFactory);
        answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "clusters"), new Object[0]);
        return answer;
    }

    public NavigationListAssert<NamedContext, NamedContextAssert> contexts() {
        this.isNotNull();
        AssertFactory<NamedContext, NamedContextAssert> assertFactory = new AssertFactory<NamedContext, NamedContextAssert>(){

            @Override
            public NamedContextAssert createAssert(NamedContext t) {
                return io.fabric8.openshift.assertions.Assertions.assertThat(t);
            }
        };
        NavigationListAssert<NamedContext, NamedContextAssert> answer = new NavigationListAssert<NamedContext, NamedContextAssert>(((Config)this.actual).getContexts(), assertFactory);
        answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "contexts"), new Object[0]);
        return answer;
    }

    public StringAssert currentContext() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((Config)this.actual).getCurrentContext()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "currentContext"), new Object[0]);
    }

    public NavigationListAssert<NamedExtension, NamedExtensionAssert> extensions() {
        this.isNotNull();
        AssertFactory<NamedExtension, NamedExtensionAssert> assertFactory = new AssertFactory<NamedExtension, NamedExtensionAssert>(){

            @Override
            public NamedExtensionAssert createAssert(NamedExtension t) {
                return io.fabric8.openshift.assertions.Assertions.assertThat(t);
            }
        };
        NavigationListAssert<NamedExtension, NamedExtensionAssert> answer = new NavigationListAssert<NamedExtension, NamedExtensionAssert>(((Config)this.actual).getExtensions(), assertFactory);
        answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "extensions"), new Object[0]);
        return answer;
    }

    public StringAssert kind() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((Config)this.actual).getKind()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "kind"), new Object[0]);
    }

    public PreferencesAssert preferences() {
        this.isNotNull();
        return (PreferencesAssert)io.fabric8.openshift.assertions.Assertions.assertThat(((Config)this.actual).getPreferences()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "preferences"), new Object[0]);
    }

    public NavigationListAssert<NamedAuthInfo, NamedAuthInfoAssert> users() {
        this.isNotNull();
        AssertFactory<NamedAuthInfo, NamedAuthInfoAssert> assertFactory = new AssertFactory<NamedAuthInfo, NamedAuthInfoAssert>(){

            @Override
            public NamedAuthInfoAssert createAssert(NamedAuthInfo t) {
                return io.fabric8.openshift.assertions.Assertions.assertThat(t);
            }
        };
        NavigationListAssert<NamedAuthInfo, NamedAuthInfoAssert> answer = new NavigationListAssert<NamedAuthInfo, NamedAuthInfoAssert>(((Config)this.actual).getUsers(), assertFactory);
        answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "users"), new Object[0]);
        return answer;
    }
}

