/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.Context;
import io.fabric8.kubernetes.api.model.ContextFluent;
import io.fabric8.kubernetes.api.model.NamedExtension;
import io.fabric8.kubernetes.api.model.NamedExtensionBuilder;
import io.fabric8.kubernetes.api.model.NamedExtensionFluentImpl;
import java.util.ArrayList;
import java.util.List;

public class ContextFluentImpl<A extends ContextFluent<A>>
extends BaseFluent<A>
implements ContextFluent<A> {
    private String cluster;
    private List<VisitableBuilder<? extends NamedExtension, ?>> extensions = new ArrayList();
    private String namespace;
    private String user;

    public ContextFluentImpl() {
    }

    public ContextFluentImpl(Context instance) {
        this.withCluster(instance.getCluster());
        this.withExtensions(instance.getExtensions());
        this.withNamespace(instance.getNamespace());
        this.withUser(instance.getUser());
    }

    @Override
    public String getCluster() {
        return this.cluster;
    }

    @Override
    public A withCluster(String cluster) {
        this.cluster = cluster;
        return (A)this;
    }

    @Override
    public A addToExtensions(NamedExtension ... items) {
        for (NamedExtension item : items) {
            NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
            this._visitables.add(builder);
            this.extensions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromExtensions(NamedExtension ... items) {
        for (NamedExtension item : items) {
            NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
            this._visitables.remove(builder);
            this.extensions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public List<NamedExtension> getExtensions() {
        return ContextFluentImpl.build(this.extensions);
    }

    @Override
    public A withExtensions(List<NamedExtension> extensions) {
        this.extensions.clear();
        if (extensions != null) {
            for (NamedExtension item : extensions) {
                this.addToExtensions(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withExtensions(NamedExtension ... extensions) {
        this.extensions.clear();
        if (extensions != null) {
            for (NamedExtension item : extensions) {
                this.addToExtensions(item);
            }
        }
        return (A)this;
    }

    @Override
    public ContextFluent.ExtensionsNested<A> addNewExtension() {
        return new ExtensionsNestedImpl();
    }

    @Override
    public ContextFluent.ExtensionsNested<A> addNewExtensionLike(NamedExtension item) {
        return new ExtensionsNestedImpl(item);
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public A withNamespace(String namespace) {
        this.namespace = namespace;
        return (A)this;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public A withUser(String user) {
        this.user = user;
        return (A)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContextFluentImpl that = (ContextFluentImpl)o;
        if (this.cluster != null ? !this.cluster.equals(that.cluster) : that.cluster != null) {
            return false;
        }
        if (this.extensions != null ? !this.extensions.equals(that.extensions) : that.extensions != null) {
            return false;
        }
        if (this.namespace != null ? !this.namespace.equals(that.namespace) : that.namespace != null) {
            return false;
        }
        return !(this.user != null ? !this.user.equals(that.user) : that.user != null);
    }

    public class ExtensionsNestedImpl<N>
    extends NamedExtensionFluentImpl<ContextFluent.ExtensionsNested<N>>
    implements ContextFluent.ExtensionsNested<N>,
    Nested<N> {
        private final NamedExtensionBuilder builder;

        ExtensionsNestedImpl() {
            this.builder = new NamedExtensionBuilder(this);
        }

        ExtensionsNestedImpl(NamedExtension item) {
            this.builder = new NamedExtensionBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ContextFluentImpl.this.addToExtensions(this.builder.build());
        }

        @Override
        public N endExtension() {
            return this.and();
        }
    }
}

