/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class PodTemplateSpecBuilder
extends PodTemplateSpecFluentImpl<PodTemplateSpecBuilder>
implements VisitableBuilder<PodTemplateSpec, PodTemplateSpecBuilder> {
    PodTemplateSpecFluent<?> fluent;
    Boolean validationEnabled;

    public PodTemplateSpecBuilder() {
        this(true);
    }

    public PodTemplateSpecBuilder(Boolean validationEnabled) {
        this(new PodTemplateSpec(), validationEnabled);
    }

    public PodTemplateSpecBuilder(PodTemplateSpecFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public PodTemplateSpecBuilder(PodTemplateSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new PodTemplateSpec(), validationEnabled);
    }

    public PodTemplateSpecBuilder(PodTemplateSpecFluent<?> fluent, PodTemplateSpec instance) {
        this(fluent, instance, true);
    }

    public PodTemplateSpecBuilder(PodTemplateSpecFluent<?> fluent, PodTemplateSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        this.validationEnabled = validationEnabled;
    }

    public PodTemplateSpecBuilder(PodTemplateSpec instance) {
        this(instance, (Boolean)true);
    }

    public PodTemplateSpecBuilder(PodTemplateSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.validationEnabled = validationEnabled;
    }

    public PodTemplateSpec build() {
        PodTemplateSpec buildable = new PodTemplateSpec(this.fluent.getMetadata(), this.fluent.getSpec());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PodTemplateSpecBuilder that = (PodTemplateSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

