/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.DeploymentCause;
import io.fabric8.openshift.api.model.DeploymentCauseFluent;
import io.fabric8.openshift.api.model.DeploymentCauseFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class DeploymentCauseBuilder
extends DeploymentCauseFluentImpl<DeploymentCauseBuilder>
implements VisitableBuilder<DeploymentCause, DeploymentCauseBuilder> {
    DeploymentCauseFluent<?> fluent;
    Boolean validationEnabled;

    public DeploymentCauseBuilder() {
        this(true);
    }

    public DeploymentCauseBuilder(Boolean validationEnabled) {
        this(new DeploymentCause(), validationEnabled);
    }

    public DeploymentCauseBuilder(DeploymentCauseFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public DeploymentCauseBuilder(DeploymentCauseFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new DeploymentCause(), validationEnabled);
    }

    public DeploymentCauseBuilder(DeploymentCauseFluent<?> fluent, DeploymentCause instance) {
        this(fluent, instance, true);
    }

    public DeploymentCauseBuilder(DeploymentCauseFluent<?> fluent, DeploymentCause instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withImageTrigger(instance.getImageTrigger());
        fluent.withType(instance.getType());
        this.validationEnabled = validationEnabled;
    }

    public DeploymentCauseBuilder(DeploymentCause instance) {
        this(instance, (Boolean)true);
    }

    public DeploymentCauseBuilder(DeploymentCause instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withImageTrigger(instance.getImageTrigger());
        this.withType(instance.getType());
        this.validationEnabled = validationEnabled;
    }

    public DeploymentCause build() {
        DeploymentCause buildable = new DeploymentCause(this.fluent.getImageTrigger(), this.fluent.getType());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeploymentCauseBuilder that = (DeploymentCauseBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

