/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.DeploymentConfigFluent;
import io.fabric8.openshift.api.model.DeploymentConfigSpec;
import io.fabric8.openshift.api.model.DeploymentConfigSpecBuilder;
import io.fabric8.openshift.api.model.DeploymentConfigSpecFluentImpl;
import io.fabric8.openshift.api.model.DeploymentConfigStatus;
import io.fabric8.openshift.api.model.DeploymentConfigStatusBuilder;
import io.fabric8.openshift.api.model.DeploymentConfigStatusFluentImpl;

public class DeploymentConfigFluentImpl<A extends DeploymentConfigFluent<A>>
extends BaseFluent<A>
implements DeploymentConfigFluent<A> {
    private String apiVersion;
    private String kind;
    private VisitableBuilder<? extends ObjectMeta, ?> metadata;
    private VisitableBuilder<? extends DeploymentConfigSpec, ?> spec;
    private VisitableBuilder<? extends DeploymentConfigStatus, ?> status;

    public DeploymentConfigFluentImpl() {
    }

    public DeploymentConfigFluentImpl(DeploymentConfig instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public ObjectMeta getMetadata() {
        return this.metadata != null ? (ObjectMeta)this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public DeploymentConfigFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public DeploymentConfigFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public DeploymentConfigFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public DeploymentConfigSpec getSpec() {
        return this.spec != null ? (DeploymentConfigSpec)this.spec.build() : null;
    }

    @Override
    public A withSpec(DeploymentConfigSpec spec) {
        if (spec != null) {
            this.spec = new DeploymentConfigSpecBuilder(spec);
            this._visitables.add(this.spec);
        }
        return (A)this;
    }

    @Override
    public DeploymentConfigFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    @Override
    public DeploymentConfigFluent.SpecNested<A> withNewSpecLike(DeploymentConfigSpec item) {
        return new SpecNestedImpl(item);
    }

    @Override
    public DeploymentConfigFluent.SpecNested<A> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    @Override
    public DeploymentConfigStatus getStatus() {
        return this.status != null ? (DeploymentConfigStatus)this.status.build() : null;
    }

    @Override
    public A withStatus(DeploymentConfigStatus status) {
        if (status != null) {
            this.status = new DeploymentConfigStatusBuilder(status);
            this._visitables.add(this.status);
        }
        return (A)this;
    }

    @Override
    public DeploymentConfigFluent.StatusNested<A> withNewStatus() {
        return new StatusNestedImpl();
    }

    @Override
    public DeploymentConfigFluent.StatusNested<A> withNewStatusLike(DeploymentConfigStatus item) {
        return new StatusNestedImpl(item);
    }

    @Override
    public DeploymentConfigFluent.StatusNested<A> editStatus() {
        return this.withNewStatusLike(this.getStatus());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeploymentConfigFluentImpl that = (DeploymentConfigFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.spec != null ? !this.spec.equals(that.spec) : that.spec != null) {
            return false;
        }
        return !(this.status != null ? !this.status.equals(that.status) : that.status != null);
    }

    public class StatusNestedImpl<N>
    extends DeploymentConfigStatusFluentImpl<DeploymentConfigFluent.StatusNested<N>>
    implements DeploymentConfigFluent.StatusNested<N>,
    Nested<N> {
        private final DeploymentConfigStatusBuilder builder;

        StatusNestedImpl() {
            this.builder = new DeploymentConfigStatusBuilder(this);
        }

        StatusNestedImpl(DeploymentConfigStatus item) {
            this.builder = new DeploymentConfigStatusBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)DeploymentConfigFluentImpl.this.withStatus(this.builder.build());
        }

        @Override
        public N endStatus() {
            return this.and();
        }
    }

    public class SpecNestedImpl<N>
    extends DeploymentConfigSpecFluentImpl<DeploymentConfigFluent.SpecNested<N>>
    implements DeploymentConfigFluent.SpecNested<N>,
    Nested<N> {
        private final DeploymentConfigSpecBuilder builder;

        SpecNestedImpl() {
            this.builder = new DeploymentConfigSpecBuilder(this);
        }

        SpecNestedImpl(DeploymentConfigSpec item) {
            this.builder = new DeploymentConfigSpecBuilder(this, item);
        }

        @Override
        public N endSpec() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)DeploymentConfigFluentImpl.this.withSpec(this.builder.build());
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<DeploymentConfigFluent.MetadataNested<N>>
    implements DeploymentConfigFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)DeploymentConfigFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

