/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.NodeStatus;
import io.fabric8.kubernetes.api.model.NodeStatusFluent;
import io.fabric8.kubernetes.api.model.NodeStatusFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class NodeStatusBuilder
extends NodeStatusFluentImpl<NodeStatusBuilder>
implements VisitableBuilder<NodeStatus, NodeStatusBuilder> {
    NodeStatusFluent<?> fluent;
    Boolean validationEnabled;

    public NodeStatusBuilder() {
        this(true);
    }

    public NodeStatusBuilder(Boolean validationEnabled) {
        this(new NodeStatus(), validationEnabled);
    }

    public NodeStatusBuilder(NodeStatusFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public NodeStatusBuilder(NodeStatusFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new NodeStatus(), validationEnabled);
    }

    public NodeStatusBuilder(NodeStatusFluent<?> fluent, NodeStatus instance) {
        this(fluent, instance, true);
    }

    public NodeStatusBuilder(NodeStatusFluent<?> fluent, NodeStatus instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAddresses(instance.getAddresses());
        fluent.withAllocatable(instance.getAllocatable());
        fluent.withCapacity(instance.getCapacity());
        fluent.withConditions(instance.getConditions());
        fluent.withDaemonEndpoints(instance.getDaemonEndpoints());
        fluent.withImages(instance.getImages());
        fluent.withNodeInfo(instance.getNodeInfo());
        fluent.withPhase(instance.getPhase());
        this.validationEnabled = validationEnabled;
    }

    public NodeStatusBuilder(NodeStatus instance) {
        this(instance, (Boolean)true);
    }

    public NodeStatusBuilder(NodeStatus instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAddresses(instance.getAddresses());
        this.withAllocatable(instance.getAllocatable());
        this.withCapacity(instance.getCapacity());
        this.withConditions(instance.getConditions());
        this.withDaemonEndpoints(instance.getDaemonEndpoints());
        this.withImages(instance.getImages());
        this.withNodeInfo(instance.getNodeInfo());
        this.withPhase(instance.getPhase());
        this.validationEnabled = validationEnabled;
    }

    public NodeStatus build() {
        NodeStatus buildable = new NodeStatus(this.fluent.getAddresses(), this.fluent.getAllocatable(), this.fluent.getCapacity(), this.fluent.getConditions(), this.fluent.getDaemonEndpoints(), this.fluent.getImages(), this.fluent.getNodeInfo(), this.fluent.getPhase());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NodeStatusBuilder that = (NodeStatusBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

