/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarAssert;
import io.fabric8.kubernetes.api.model.ObjectMetaAssert;
import io.fabric8.kubernetes.api.model.ObjectReferenceAssert;
import io.fabric8.kubernetes.assertions.AssertFactory;
import io.fabric8.kubernetes.assertions.NavigationListAssert;
import io.fabric8.openshift.api.model.BinaryBuildSourceAssert;
import io.fabric8.openshift.api.model.BuildRequest;
import io.fabric8.openshift.api.model.SourceRevisionAssert;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.StringAssert;
import org.assertj.core.util.Objects;

public abstract class AbstractBuildRequestAssert<S extends AbstractBuildRequestAssert<S, A>, A extends BuildRequest>
extends AbstractAssert<S, A> {
    protected AbstractBuildRequestAssert(A actual, Class<S> selfType) {
        super(actual, selfType);
    }

    public MapAssert additionalProperties() {
        this.isNotNull();
        return (MapAssert)Assertions.assertThat(((BuildRequest)this.actual).getAdditionalProperties()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "additionalProperties"), new Object[0]);
    }

    public StringAssert apiVersion() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((BuildRequest)this.actual).getApiVersion()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "apiVersion"), new Object[0]);
    }

    public BinaryBuildSourceAssert binary() {
        this.isNotNull();
        return (BinaryBuildSourceAssert)io.fabric8.openshift.assertions.Assertions.assertThat(((BuildRequest)this.actual).getBinary()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "binary"), new Object[0]);
    }

    public NavigationListAssert<EnvVar, EnvVarAssert> env() {
        this.isNotNull();
        AssertFactory<EnvVar, EnvVarAssert> assertFactory = new AssertFactory<EnvVar, EnvVarAssert>(){

            @Override
            public EnvVarAssert createAssert(EnvVar t) {
                return io.fabric8.openshift.assertions.Assertions.assertThat(t);
            }
        };
        NavigationListAssert<EnvVar, EnvVarAssert> answer = new NavigationListAssert<EnvVar, EnvVarAssert>(((BuildRequest)this.actual).getEnv(), assertFactory);
        answer.describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "env"), new Object[0]);
        return answer;
    }

    public ObjectReferenceAssert from() {
        this.isNotNull();
        return (ObjectReferenceAssert)io.fabric8.openshift.assertions.Assertions.assertThat(((BuildRequest)this.actual).getFrom()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "from"), new Object[0]);
    }

    public StringAssert kind() {
        this.isNotNull();
        return (StringAssert)Assertions.assertThat((String)((BuildRequest)this.actual).getKind()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "kind"), new Object[0]);
    }

    public S hasLastVersion(Integer lastVersion) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting lastVersion of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Integer actualLastVersion = ((BuildRequest)this.actual).getLastVersion();
        if (!Objects.areEqual((Object)actualLastVersion, (Object)lastVersion)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, lastVersion, actualLastVersion});
        }
        return (S)((Object)((AbstractBuildRequestAssert)this.myself));
    }

    public ObjectMetaAssert metadata() {
        this.isNotNull();
        return (ObjectMetaAssert)io.fabric8.openshift.assertions.Assertions.assertThat(((BuildRequest)this.actual).getMetadata()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "metadata"), new Object[0]);
    }

    public SourceRevisionAssert revision() {
        this.isNotNull();
        return (SourceRevisionAssert)io.fabric8.openshift.assertions.Assertions.assertThat(((BuildRequest)this.actual).getRevision()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "revision"), new Object[0]);
    }

    public ObjectReferenceAssert triggeredByImage() {
        this.isNotNull();
        return (ObjectReferenceAssert)io.fabric8.openshift.assertions.Assertions.assertThat(((BuildRequest)this.actual).getTriggeredByImage()).describedAs(io.fabric8.kubernetes.assertions.Assertions.joinDescription(this, "triggeredByImage"), new Object[0]);
    }
}

