/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.BuildSource;
import io.fabric8.openshift.api.model.BuildSourceFluent;
import io.fabric8.openshift.api.model.BuildSourceFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class BuildSourceBuilder
extends BuildSourceFluentImpl<BuildSourceBuilder>
implements VisitableBuilder<BuildSource, BuildSourceBuilder> {
    BuildSourceFluent<?> fluent;

    public BuildSourceBuilder() {
        this(new BuildSource());
    }

    public BuildSourceBuilder(BuildSourceFluent<?> fluent) {
        this(fluent, new BuildSource());
    }

    public BuildSourceBuilder(BuildSourceFluent<?> fluent, BuildSource instance) {
        this.fluent = fluent;
        fluent.withBinary(instance.getBinary());
        fluent.withContextDir(instance.getContextDir());
        fluent.withDockerfile(instance.getDockerfile());
        fluent.withGit(instance.getGit());
        fluent.withImages(instance.getImages());
        fluent.withSecrets(instance.getSecrets());
        fluent.withSourceSecret(instance.getSourceSecret());
        fluent.withType(instance.getType());
    }

    public BuildSourceBuilder(BuildSource instance) {
        this.fluent = this;
        this.withBinary(instance.getBinary());
        this.withContextDir(instance.getContextDir());
        this.withDockerfile(instance.getDockerfile());
        this.withGit(instance.getGit());
        this.withImages(instance.getImages());
        this.withSecrets(instance.getSecrets());
        this.withSourceSecret(instance.getSourceSecret());
        this.withType(instance.getType());
    }

    public BuildSource build() {
        BuildSource buildable = new BuildSource(this.fluent.getBinary(), this.fluent.getContextDir(), this.fluent.getDockerfile(), this.fluent.getGit(), this.fluent.getImages(), this.fluent.getSecrets(), this.fluent.getSourceSecret(), this.fluent.getType());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BuildSourceBuilder that = (BuildSourceBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

