/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ResourceQuotaStatus;
import io.fabric8.kubernetes.api.model.ResourceQuotaStatusFluent;
import io.fabric8.kubernetes.api.model.ResourceQuotaStatusFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ResourceQuotaStatusBuilder
extends ResourceQuotaStatusFluentImpl<ResourceQuotaStatusBuilder>
implements VisitableBuilder<ResourceQuotaStatus, ResourceQuotaStatusBuilder> {
    ResourceQuotaStatusFluent<?> fluent;

    public ResourceQuotaStatusBuilder() {
        this(new ResourceQuotaStatus());
    }

    public ResourceQuotaStatusBuilder(ResourceQuotaStatusFluent<?> fluent) {
        this(fluent, new ResourceQuotaStatus());
    }

    public ResourceQuotaStatusBuilder(ResourceQuotaStatusFluent<?> fluent, ResourceQuotaStatus instance) {
        this.fluent = fluent;
        fluent.withHard(instance.getHard());
        fluent.withUsed(instance.getUsed());
    }

    public ResourceQuotaStatusBuilder(ResourceQuotaStatus instance) {
        this.fluent = this;
        this.withHard(instance.getHard());
        this.withUsed(instance.getUsed());
    }

    public ResourceQuotaStatus build() {
        ResourceQuotaStatus buildable = new ResourceQuotaStatus(this.fluent.getHard(), this.fluent.getUsed());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResourceQuotaStatusBuilder that = (ResourceQuotaStatusBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

