/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.DownwardAPIVolumeSource;
import io.fabric8.kubernetes.api.model.DownwardAPIVolumeSourceFluent;
import io.fabric8.kubernetes.api.model.DownwardAPIVolumeSourceFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class DownwardAPIVolumeSourceBuilder
extends DownwardAPIVolumeSourceFluentImpl<DownwardAPIVolumeSourceBuilder>
implements VisitableBuilder<DownwardAPIVolumeSource, DownwardAPIVolumeSourceBuilder> {
    DownwardAPIVolumeSourceFluent<?> fluent;

    public DownwardAPIVolumeSourceBuilder() {
        this(new DownwardAPIVolumeSource());
    }

    public DownwardAPIVolumeSourceBuilder(DownwardAPIVolumeSourceFluent<?> fluent) {
        this(fluent, new DownwardAPIVolumeSource());
    }

    public DownwardAPIVolumeSourceBuilder(DownwardAPIVolumeSourceFluent<?> fluent, DownwardAPIVolumeSource instance) {
        this.fluent = fluent;
        fluent.withItems(instance.getItems());
    }

    public DownwardAPIVolumeSourceBuilder(DownwardAPIVolumeSource instance) {
        this.fluent = this;
        this.withItems(instance.getItems());
    }

    public DownwardAPIVolumeSource build() {
        DownwardAPIVolumeSource buildable = new DownwardAPIVolumeSource(this.fluent.getItems());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DownwardAPIVolumeSourceBuilder that = (DownwardAPIVolumeSourceBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

